/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.minis.behavior.veil;

import org.apache.wicket.Component;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.util.string.Strings;
import org.wicketstuff.minis.behavior.veil.VeilResources;

public class Veil
extends VeilResources {
    private static final long serialVersionUID = 1L;
    private Component component;
    private String cssClassName;

    public Veil() {
    }

    public Veil(String cssClassName) {
        if (!Strings.isEmpty((CharSequence)cssClassName)) {
            this.cssClassName = cssClassName;
        }
    }

    public void bind(Component component) {
        super.bind(component);
        if (this.component != null) {
            throw new IllegalStateException("This behavior is already bound to component. An instance of this behavior cannot be reused between components. Bound component: " + this.component.toString());
        }
        this.component = component;
    }

    private String getCssClassName() {
        return this.cssClassName != null ? this.cssClassName : "wicket-veil";
    }

    public void renderHead(Component c, IHeaderResponse response) {
        super.renderHead(c, response);
        response.renderOnDomReadyJavaScript(VeilResources.Javascript.show(this.component));
    }
}

