/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.minis.component;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ListViewFormComponentReuseManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final MetaDataKey<ListViewFormComponentReuseManager> REUSE_MANAGER_META_KEY = new MetaDataKey<ListViewFormComponentReuseManager>(){
        private static final long serialVersionUID = 1L;
    };
    private final Map<Object, Map<String, FormComponent<?>>> componentsByRowModelObject = new HashMap();

    public static <T extends FormComponent<?>> T addOrReuse(MarkupContainer parent, T newComponent) {
        Object rowModelObject = null;
        for (MarkupContainer current = parent; current != null; current = current.getParent()) {
            if (current instanceof ListItem) {
                rowModelObject = current.getDefaultModelObject();
            }
            if (!(current instanceof ListView)) continue;
            ListViewFormComponentReuseManager mgr = (ListViewFormComponentReuseManager)current.getMetaData(REUSE_MANAGER_META_KEY);
            if (mgr == null) {
                mgr = new ListViewFormComponentReuseManager();
                current.setMetaData(REUSE_MANAGER_META_KEY, (Object)mgr);
            }
            T componentToUse = mgr.rememberOrReuse(rowModelObject, newComponent);
            parent.add(new Component[]{componentToUse});
            return componentToUse;
        }
        return newComponent;
    }

    private ListViewFormComponentReuseManager() {
    }

    private <T extends FormComponent<?>> T rememberOrReuse(Object rowModelObject, T newComponent) {
        FormComponent<?> existingComponent;
        Map<String, FormComponent<?>> rowComponents = this.componentsByRowModelObject.get(rowModelObject);
        if (rowComponents == null) {
            rowComponents = new HashMap();
            this.componentsByRowModelObject.put(rowModelObject, rowComponents);
        }
        if ((existingComponent = rowComponents.get(newComponent.getId())) == null) {
            rowComponents.put(newComponent.getId(), newComponent);
            return newComponent;
        }
        return (T)existingComponent;
    }
}

