/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.sso.coarse;

import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.context.Flag;
import org.wildfly.clustering.ee.infinispan.CacheEntryMutator;
import org.wildfly.clustering.ee.infinispan.Mutator;
import org.wildfly.clustering.web.infinispan.sso.SessionsFactory;
import org.wildfly.clustering.web.infinispan.sso.coarse.CoarseSessions;
import org.wildfly.clustering.web.infinispan.sso.coarse.CoarseSessionsKey;
import org.wildfly.clustering.web.infinispan.sso.coarse.SessionFilter;
import org.wildfly.clustering.web.infinispan.sso.coarse.SessionsFilter;
import org.wildfly.clustering.web.sso.Sessions;

public class CoarseSessionsFactory<D>
implements SessionsFactory<Map<D, String>, D> {
    private final SessionsFilter<D> filter = new SessionsFilter();
    private final Cache<CoarseSessionsKey, Map<D, String>> cache;

    public CoarseSessionsFactory(Cache<CoarseSessionsKey, Map<D, String>> cache) {
        this.cache = cache;
    }

    @Override
    public Sessions<D> createSessions(String ssoId, Map<D, String> value) {
        CoarseSessionsKey key = new CoarseSessionsKey(ssoId);
        CacheEntryMutator mutator = new CacheEntryMutator(this.cache, (Object)key, value);
        return new CoarseSessions<D>(value, (Mutator)mutator);
    }

    public Map<D, String> createValue(String id, Void context) {
        ConcurrentHashMap sessions = new ConcurrentHashMap();
        this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)new CoarseSessionsKey(id), sessions);
        return sessions;
    }

    public Map<D, String> findValue(String id) {
        return (Map)this.cache.get((Object)new CoarseSessionsKey(id));
    }

    @Override
    public Map.Entry<String, Map<D, String>> findEntryContaining(String sessionId) {
        SessionFilter filter = new SessionFilter(sessionId);
        Cache<CoarseSessionsKey, Map<D, String>> cache = this.cache;
        try (CacheStream stream = cache.entrySet().stream();){
            Map.Entry entry = stream.filter(this.filter).map(this.filter).filter(filter).findAny().orElse(null);
            AbstractMap.SimpleImmutableEntry simpleImmutableEntry = entry != null ? new AbstractMap.SimpleImmutableEntry(((CoarseSessionsKey)((Object)entry.getKey())).getValue(), entry.getValue()) : null;
            return simpleImmutableEntry;
        }
    }

    public boolean remove(String id) {
        this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).remove((Object)new CoarseSessionsKey(id));
        return true;
    }
}

