/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.accesscontrol.AccessRequirement;
import org.jboss.as.cli.accesscontrol.AccessRequirementBuilder;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.DefaultFilenameTabCompleter;
import org.jboss.as.cli.handlers.DeploymentHandler;
import org.jboss.as.cli.handlers.FilenameTabCompleter;
import org.jboss.as.cli.handlers.WindowsFilenameTabCompleter;
import org.jboss.as.cli.impl.ArgumentWithListValue;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.cli.impl.CommaSeparatedCompleter;
import org.jboss.as.cli.impl.FileSystemPathArgument;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.spi.MountHandle;

public class UndeployHandler
extends DeploymentHandler {
    private final ArgumentWithoutValue l;
    private final ArgumentWithoutValue path;
    private final ArgumentWithValue name;
    private final ArgumentWithListValue serverGroups;
    private final ArgumentWithoutValue allRelevantServerGroups;
    private final ArgumentWithoutValue keepContent;
    private final ArgumentWithValue script;
    private AccessRequirement listPermission;
    private AccessRequirement mainRemovePermission;
    private AccessRequirement undeployPermission;

    public UndeployHandler(CommandContext ctx) {
        super(ctx, "undeploy", true);
        DefaultOperationRequestAddress requiredAddress = new DefaultOperationRequestAddress();
        requiredAddress.toNodeType("deployment");
        this.addRequiredPath(requiredAddress);
        this.l = new ArgumentWithoutValue(this, "-l");
        this.l.setExclusive(true);
        this.l.setAccessRequirement(this.listPermission);
        AccessRequirement removeOrUndeployPermission = AccessRequirementBuilder.Factory.create(ctx).any().requirement(this.mainRemovePermission).requirement(this.undeployPermission).build();
        this.name = new ArgumentWithValue((CommandHandlerWithArguments)this, new CommandLineCompleter(){

            @Override
            public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
                int nextCharIndex;
                ParsedCommandLine args = ctx.getParsedCommandLine();
                try {
                    if (UndeployHandler.this.path.isPresent(args)) {
                        return -1;
                    }
                }
                catch (CommandFormatException e) {
                    return -1;
                }
                for (nextCharIndex = 0; nextCharIndex < buffer.length() && Character.isWhitespace(buffer.charAt(nextCharIndex)); ++nextCharIndex) {
                }
                if (ctx.getModelControllerClient() != null) {
                    List<String> deployments = Util.getDeployments(ctx.getModelControllerClient());
                    if (deployments.isEmpty()) {
                        return -1;
                    }
                    String opBuffer = buffer.substring(nextCharIndex).trim();
                    if (opBuffer.isEmpty()) {
                        candidates.addAll(deployments);
                    } else {
                        for (String name : deployments) {
                            if (!name.startsWith(opBuffer)) continue;
                            candidates.add(name);
                        }
                        Collections.sort(candidates);
                    }
                    return nextCharIndex;
                }
                return -1;
            }
        }, 0, "--name");
        this.name.addCantAppearAfter(this.l);
        this.name.setAccessRequirement(removeOrUndeployPermission);
        this.allRelevantServerGroups = new ArgumentWithoutValue(this, "--all-relevant-server-groups"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (!ctx.isDomainMode()) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.allRelevantServerGroups.addRequiredPreceding(this.name);
        this.allRelevantServerGroups.setAccessRequirement(this.undeployPermission);
        this.serverGroups = new ArgumentWithListValue(this, new CommaSeparatedCompleter(){

            @Override
            protected Collection<String> getAllCandidates(CommandContext ctx) {
                List<String> allGroups;
                String deploymentName = UndeployHandler.this.name.getValue(ctx.getParsedCommandLine());
                try {
                    allGroups = Util.getServerGroupsReferencingDeployment(deploymentName, ctx.getModelControllerClient());
                }
                catch (CommandLineException e) {
                    e.printStackTrace();
                    return Collections.emptyList();
                }
                return allGroups;
            }
        }, "--server-groups"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (!ctx.isDomainMode()) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.serverGroups.addRequiredPreceding(this.name);
        this.serverGroups.setAccessRequirement(this.undeployPermission);
        this.serverGroups.addCantAppearAfter(this.allRelevantServerGroups);
        this.allRelevantServerGroups.addCantAppearAfter(this.serverGroups);
        this.keepContent = new ArgumentWithoutValue(this, "--keep-content");
        this.keepContent.addRequiredPreceding(this.name);
        this.keepContent.setAccessRequirement(this.undeployPermission);
        FilenameTabCompleter pathCompleter = Util.isWindows() ? new WindowsFilenameTabCompleter(ctx) : new DefaultFilenameTabCompleter(ctx);
        this.path = new FileSystemPathArgument((CommandHandlerWithArguments)this, pathCompleter, "--path");
        this.path.addCantAppearAfter(this.l);
        this.path.setAccessRequirement(removeOrUndeployPermission);
        this.script = new ArgumentWithValue(this, "--script");
        this.script.addRequiredPreceding(this.path);
    }

    @Override
    protected AccessRequirement setupAccessRequirement(CommandContext ctx) {
        this.listPermission = AccessRequirementBuilder.Factory.create(ctx).all().operation("read-children-names").operation("deployment=?", "read-resource").build();
        this.mainRemovePermission = AccessRequirementBuilder.Factory.create(ctx).any().operation("deployment=?", "remove").build();
        this.undeployPermission = AccessRequirementBuilder.Factory.create(ctx).any().operation("deployment=?", "undeploy").all().serverGroupOperation("deployment=?", "remove").serverGroupOperation("deployment=?", "undeploy").parent().build();
        return AccessRequirementBuilder.Factory.create(ctx).any().requirement(this.listPermission).requirement(this.mainRemovePermission).requirement(this.undeployPermission).build();
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandLineException {
        ModelNode result;
        File f;
        ModelControllerClient client = ctx.getModelControllerClient();
        ParsedCommandLine args = ctx.getParsedCommandLine();
        boolean l = this.l.isPresent(args);
        if (!args.hasProperties() || l) {
            this.listDeployments(ctx, l);
            return;
        }
        String path = this.path.getValue(args);
        if (path != null) {
            f = new File(path);
            if (!f.exists()) {
                throw new CommandFormatException("Path '" + f.getAbsolutePath() + "' doesn't exist.");
            }
            if (!this.isCliArchive(f)) {
                throw new CommandFormatException("File '" + f.getAbsolutePath() + "' is not a valid CLI archive. CLI archives should have a '.cli' extension.");
            }
        } else {
            f = null;
        }
        if (this.isCliArchive(f)) {
            ModelNode request = this.buildRequest(ctx);
            if (request == null) {
                throw new CommandFormatException("Operation request wasn't built.");
            }
            try {
                ModelNode result2 = client.execute(request);
                if (Util.isSuccess(result2)) {
                    return;
                }
                throw new CommandFormatException("Failed to execute archive script: " + Util.getFailureDescription(result2));
            }
            catch (IOException e) {
                throw new CommandFormatException("Failed to execute archive script: " + e.getLocalizedMessage(), e);
            }
        }
        String name = this.name.getValue(ctx.getParsedCommandLine());
        if (name == null) {
            this.printList(ctx, Util.getDeployments(client), l);
            return;
        }
        ModelNode request = this.buildRequestWOValidation(ctx);
        this.addHeaders(ctx, request);
        try {
            result = client.execute(request);
        }
        catch (Exception e) {
            throw new CommandFormatException("Undeploy failed: " + e.getLocalizedMessage());
        }
        if (!Util.isSuccess(result)) {
            throw new CommandFormatException("Undeploy failed: " + Util.getFailureDescription(result));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public ModelNode buildRequestWithoutHeaders(CommandContext ctx) throws CommandFormatException {
        DefaultOperationRequestBuilder builder;
        List<String> deploymentNames;
        File f;
        ModelNode composite = new ModelNode();
        composite.get("operation").set("composite");
        composite.get("address").setEmptyList();
        ModelNode steps = composite.get("steps");
        ParsedCommandLine args = ctx.getParsedCommandLine();
        String name = this.name.getValue(args);
        boolean keepContent = this.keepContent.isPresent(args);
        boolean allRelevantServerGroups = this.allRelevantServerGroups.isPresent(args);
        String serverGroupsStr = this.serverGroups.getValue(args);
        String path = this.path.getValue(args);
        if (path != null) {
            f = new File(path);
            if (!f.exists()) {
                throw new OperationFormatException("Path '" + f.getAbsolutePath() + "' doesn't exist.");
            }
            if (!this.isCliArchive(f)) {
                throw new OperationFormatException("File '" + f.getAbsolutePath() + "' is not a valid CLI archive. CLI archives should have a '.cli' extension.");
            }
        } else {
            f = null;
        }
        if (this.isCliArchive(f)) {
            ModelNode modelNode;
            MountHandle root;
            TempFileProvider tempFileProvider;
            if (name != null) {
                throw new OperationFormatException(this.name.getFullName() + " can't be used in combination with a CLI archive.");
            }
            if (serverGroupsStr != null || allRelevantServerGroups) {
                throw new OperationFormatException(this.serverGroups.getFullName() + " and " + this.allRelevantServerGroups.getFullName() + " can't be used in combination with a CLI archive.");
            }
            if (keepContent) {
                throw new OperationFormatException(this.keepContent.getFullName() + " can't be used in combination with a CLI archive.");
            }
            try {
                tempFileProvider = TempFileProvider.create((String)"cli", (ScheduledExecutorService)Executors.newSingleThreadScheduledExecutor(), (boolean)true);
                root = this.extractArchive(f, tempFileProvider);
            }
            catch (IOException e2) {
                throw new OperationFormatException("Unable to extract archive '" + f.getAbsolutePath() + "' to temporary location");
            }
            File currentDir = ctx.getCurrentDir();
            ctx.setCurrentDir(root.getMountSource());
            String holdbackBatch = this.activateNewBatch(ctx);
            try {
                File scriptFile;
                String script = this.script.getValue(args);
                if (script == null) {
                    script = "undeploy.scr";
                }
                if (!(scriptFile = new File(ctx.getCurrentDir(), script)).exists()) {
                    throw new CommandFormatException("ERROR: script '" + script + "' not found in archive '" + f.getAbsolutePath() + "'.");
                }
                BufferedReader reader = null;
                try {
                    void var18_28;
                    reader = new BufferedReader(new FileReader(scriptFile));
                    String string = reader.readLine();
                    while (!ctx.isTerminated() && var18_28 != null) {
                        ctx.handle((String)var18_28);
                        String string2 = reader.readLine();
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new CommandFormatException("ERROR: script '" + script + "' not found in archive '" + f.getAbsolutePath() + "'.");
                }
                catch (IOException iOException) {
                    throw new CommandFormatException("Failed to read the next command from " + scriptFile.getName() + ": " + iOException.getMessage(), iOException);
                }
                catch (CommandLineException commandLineException) {
                    throw new CommandFormatException(commandLineException.getMessage(), commandLineException);
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                modelNode = ctx.getBatchManager().getActiveBatch().toRequest();
                ctx.setCurrentDir(currentDir);
            }
            catch (Throwable throwable) {
                ctx.setCurrentDir(currentDir);
                this.discardBatch(ctx, holdbackBatch);
                VFSUtils.safeClose((Closeable[])new Closeable[]{root, tempFileProvider});
                throw throwable;
            }
            this.discardBatch(ctx, holdbackBatch);
            VFSUtils.safeClose((Closeable[])new Closeable[]{root, tempFileProvider});
            return modelNode;
        }
        if (name == null) {
            throw new OperationFormatException("Deployment name is missing.");
        }
        ModelControllerClient client = ctx.getModelControllerClient();
        if (name.indexOf(42) < 0) {
            deploymentNames = Collections.singletonList(name);
        } else {
            deploymentNames = Util.getMatchingDeployments(client, name, null);
            if (deploymentNames.isEmpty()) {
                throw new CommandFormatException("No deployment matched wildcard expression " + name);
            }
        }
        for (String deploymentName : deploymentNames) {
            if (ctx.isDomainMode()) {
                List<Object> serverGroups;
                if (allRelevantServerGroups) {
                    if (keepContent) {
                        serverGroups = Util.getAllEnabledServerGroups(deploymentName, client);
                    } else {
                        try {
                            serverGroups = Util.getServerGroupsReferencingDeployment(deploymentName, client);
                        }
                        catch (CommandLineException e) {
                            throw new CommandFormatException("Failed to retrieve all referencing server groups", e);
                        }
                    }
                } else {
                    serverGroups = serverGroupsStr == null ? Collections.emptyList() : Arrays.asList(serverGroupsStr.split(","));
                }
                if (serverGroups.isEmpty()) {
                    if (!keepContent) continue;
                    throw new OperationFormatException("None of the server groups is specified or references specified deployment.");
                }
                for (String string : serverGroups) {
                    ModelNode groupStep = Util.configureDeploymentOperation("undeploy", deploymentName, string);
                    steps.add(groupStep);
                    groupStep = Util.configureDeploymentOperation("remove", deploymentName, string);
                    steps.add(groupStep);
                }
                continue;
            }
            if (!Util.isDeployedAndEnabledInStandalone(deploymentName, client)) continue;
            builder = new DefaultOperationRequestBuilder();
            builder.setOperationName("undeploy");
            builder.addNode("deployment", deploymentName);
            steps.add(builder.buildRequest());
        }
        if (!keepContent) {
            for (String deploymentName : deploymentNames) {
                builder = new DefaultOperationRequestBuilder();
                builder.setOperationName("remove");
                builder.addNode("deployment", deploymentName);
                steps.add(builder.buildRequest());
            }
        }
        return composite;
    }
}

