/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.util.Collection;
import java.util.LinkedList;
import java.util.ServiceLoader;
import org.infinispan.configuration.cache.CacheMode;
import org.wildfly.clustering.infinispan.spi.service.CacheBuilder;
import org.wildfly.clustering.infinispan.spi.service.TemplateConfigurationBuilder;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.spi.CacheGroupAliasBuilderProvider;
import org.wildfly.clustering.spi.CacheGroupBuilderProvider;

public class ClientMappingsCacheBuilderProvider
implements CacheGroupBuilderProvider,
CacheGroupAliasBuilderProvider {
    private final Class<? extends CacheGroupBuilderProvider> providerClass;

    ClientMappingsCacheBuilderProvider(Class<? extends CacheGroupBuilderProvider> providerClass) {
        this.providerClass = providerClass;
    }

    public Collection<Builder<?>> getBuilders(String containerName, String cacheName) {
        LinkedList builders = new LinkedList();
        if (cacheName.equals("default")) {
            builders.add((Builder<?>)new TemplateConfigurationBuilder(containerName, "client-mappings", cacheName, builder -> {
                CacheMode mode = builder.clustering().cacheMode();
                builder.clustering().cacheMode(mode.isClustered() ? CacheMode.REPL_SYNC : CacheMode.LOCAL);
                builder.persistence().clearStores();
            }));
            builders.add((Builder<?>)new CacheBuilder(containerName, "client-mappings"));
            for (CacheGroupBuilderProvider cacheGroupBuilderProvider : ServiceLoader.load(this.providerClass, this.providerClass.getClassLoader())) {
                builders.addAll(cacheGroupBuilderProvider.getBuilders(containerName, "client-mappings"));
            }
        }
        return builders;
    }

    public Collection<Builder<?>> getBuilders(String containerName, String aliasCacheName, String targetCacheName) {
        return this.getBuilders(containerName, aliasCacheName);
    }
}

