/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet.deployment;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.batch.operations.JobExecutionAlreadyCompleteException;
import javax.batch.operations.JobExecutionNotMostRecentException;
import javax.batch.operations.JobExecutionNotRunningException;
import javax.batch.operations.JobOperator;
import javax.batch.operations.JobRestartException;
import javax.batch.operations.JobSecurityException;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleMapAttributeDefinition;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.batch.jberet.BatchResourceDescriptionResolver;
import org.wildfly.extension.batch.jberet.deployment.JobOperationReadOnlyStepHandler;
import org.wildfly.extension.batch.jberet.deployment.JobOperationStepHandler;

public class BatchJobExecutionResourceDefinition
extends SimpleResourceDefinition {
    static final String EXECUTION = "execution";
    static final SimpleAttributeDefinition INSTANCE_ID = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"instance-id", (ModelType)ModelType.LONG).setStorageRuntime()).build();
    static final SimpleAttributeDefinition BATCH_STATUS = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"batch-status", (ModelType)ModelType.STRING).setStorageRuntime()).build();
    static final SimpleAttributeDefinition EXIT_STATUS = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"exit-status", (ModelType)ModelType.STRING).setStorageRuntime()).build();
    static final SimpleAttributeDefinition CREATE_TIME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"create-time", (ModelType)ModelType.STRING).setStorageRuntime()).build();
    static final SimpleAttributeDefinition START_TIME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"start-time", (ModelType)ModelType.STRING).setStorageRuntime()).build();
    static final SimpleAttributeDefinition LAST_UPDATED_TIME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"last-updated-time", (ModelType)ModelType.STRING).setStorageRuntime()).build();
    static final SimpleAttributeDefinition END_TIME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"end-time", (ModelType)ModelType.STRING).setStorageRuntime()).build();
    static final String ISO_8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final ResourceDescriptionResolver DEFAULT_RESOLVER = BatchResourceDescriptionResolver.getResourceDescriptionResolver("deployment", "job", "execution");
    private static final SimpleMapAttributeDefinition PROPERTIES = new SimpleMapAttributeDefinition.Builder("properties", ModelType.STRING, true).build();
    private static final SimpleOperationDefinition RESTART_JOB = new SimpleOperationDefinitionBuilder("restart-job", DEFAULT_RESOLVER).setParameters(new AttributeDefinition[]{PROPERTIES}).setReplyType(ModelType.LONG).setRuntimeOnly().build();
    private static final SimpleOperationDefinition STOP_JOB = new SimpleOperationDefinitionBuilder("stop-job", DEFAULT_RESOLVER).setRuntimeOnly().build();

    public BatchJobExecutionResourceDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)EXECUTION), DEFAULT_RESOLVER).setRuntime());
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)INSTANCE_ID, (OperationStepHandler)new JobOperationReadOnlyStepHandler(){

            @Override
            protected void updateModel(OperationContext context, ModelNode model, JobOperator jobOperator, String jobName) throws OperationFailedException {
                JobInstance jobInstance = jobOperator.getJobInstance(Long.parseLong(context.getCurrentAddressValue()));
                model.set(jobInstance.getInstanceId());
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)BATCH_STATUS, (OperationStepHandler)new JobExecutionOperationStepHandler(){

            @Override
            protected void updateModel(ModelNode model, JobExecution jobExecution) throws OperationFailedException {
                BatchStatus status = jobExecution.getBatchStatus();
                if (status != null) {
                    model.set(status.toString());
                }
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)EXIT_STATUS, (OperationStepHandler)new JobExecutionOperationStepHandler(){

            @Override
            protected void updateModel(ModelNode model, JobExecution jobExecution) throws OperationFailedException {
                String exitStatus = jobExecution.getExitStatus();
                if (exitStatus != null) {
                    model.set(exitStatus);
                }
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)CREATE_TIME, (OperationStepHandler)new DateTimeFormatterOperationStepHandler(){

            @Override
            protected Date getDateTime(JobExecution jobExecution) {
                return jobExecution.getCreateTime();
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)START_TIME, (OperationStepHandler)new DateTimeFormatterOperationStepHandler(){

            @Override
            protected Date getDateTime(JobExecution jobExecution) {
                return jobExecution.getStartTime();
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)LAST_UPDATED_TIME, (OperationStepHandler)new DateTimeFormatterOperationStepHandler(){

            @Override
            protected Date getDateTime(JobExecution jobExecution) {
                return jobExecution.getLastUpdatedTime();
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)END_TIME, (OperationStepHandler)new DateTimeFormatterOperationStepHandler(){

            @Override
            protected Date getDateTime(JobExecution jobExecution) {
                return jobExecution.getEndTime();
            }
        });
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler((OperationDefinition)STOP_JOB, (OperationStepHandler)new JobOperationStepHandler(){

            @Override
            protected void execute(OperationContext context, ModelNode operation, JobOperator jobOperator) throws OperationFailedException {
                long executionId = Long.parseLong(context.getCurrentAddressValue());
                try {
                    jobOperator.stop(executionId);
                }
                catch (JobExecutionNotRunningException | JobSecurityException | NoSuchJobExecutionException e) {
                    throw 8.createOperationFailure(e);
                }
            }
        });
        resourceRegistration.registerOperationHandler((OperationDefinition)RESTART_JOB, (OperationStepHandler)new JobOperationStepHandler(){

            @Override
            protected void execute(OperationContext context, ModelNode operation, JobOperator jobOperator) throws OperationFailedException {
                long executionId = Long.parseLong(context.getCurrentAddressValue());
                Properties properties = 9.resolvePropertyValue(context, operation, (AttributeDefinition)PROPERTIES);
                try {
                    long newExecutionId = jobOperator.restart(executionId, properties);
                    context.getResult().set(newExecutionId);
                }
                catch (JobExecutionAlreadyCompleteException | JobExecutionNotMostRecentException | JobRestartException | JobSecurityException | NoSuchJobExecutionException e) {
                    throw 9.createOperationFailure(e);
                }
            }
        });
    }

    static abstract class DateTimeFormatterOperationStepHandler
    extends JobExecutionOperationStepHandler {
        DateTimeFormatterOperationStepHandler() {
        }

        @Override
        protected void updateModel(ModelNode model, JobExecution jobExecution) throws OperationFailedException {
            Date date = this.getDateTime(jobExecution);
            if (date != null) {
                SimpleDateFormat formatter = new SimpleDateFormat(BatchJobExecutionResourceDefinition.ISO_8601_FORMAT);
                model.set(formatter.format(date));
            }
        }

        protected abstract Date getDateTime(JobExecution var1);
    }

    static abstract class JobExecutionOperationStepHandler
    extends JobOperationReadOnlyStepHandler {
        JobExecutionOperationStepHandler() {
        }

        @Override
        protected void updateModel(OperationContext context, ModelNode model, JobOperator jobOperator, String jobName) throws OperationFailedException {
            JobExecution jobExecution = jobOperator.getJobExecution(Long.parseLong(context.getCurrentAddressValue()));
            this.updateModel(model, jobExecution);
        }

        protected abstract void updateModel(ModelNode var1, JobExecution var2) throws OperationFailedException;
    }
}

