/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.support;

import org.apache.commons.lang3.Validate;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.util.ObjectFactory;

public class ObjectPoolHelper<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectPoolHelper.class);
    private static final int MAX_IDLE = 5;
    private static final long MAX_WAIT = 10000L;
    private static final long EVICTABLE_IDLE_TIME = 30000L;
    private GenericObjectPool<T> objectPool;

    public ObjectPoolHelper(ObjectFactory<T> objectFactory) {
        Validate.notNull(objectFactory);
        this.objectPool = this.createObjectPool(objectFactory);
        Validate.notNull(this.objectPool);
    }

    private GenericObjectPool<T> createObjectPool(ObjectFactory<T> objectFactory) {
        GenericObjectPool<T> pool = this.newObjectPool(objectFactory);
        Validate.notNull(pool);
        return pool;
    }

    protected GenericObjectPool<T> newObjectPool(final ObjectFactory<T> objectFactory) {
        int maxActive = Math.max(2, Runtime.getRuntime().availableProcessors());
        GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)new BasePooledObjectFactory<T>(){

            public T create() throws Exception {
                return objectFactory.create();
            }

            public PooledObject<T> wrap(T obj) {
                return new DefaultPooledObject(obj);
            }
        });
        pool.setMaxTotal(maxActive);
        pool.setMaxIdle(5);
        pool.setMaxWaitMillis(10000L);
        pool.setBlockWhenExhausted(true);
        pool.setSoftMinEvictableIdleTimeMillis(30000L);
        pool.setTimeBetweenEvictionRunsMillis(30000L);
        return pool;
    }

    public T getObject() {
        try {
            return (T)this.objectPool.borrowObject();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get object from the pool", e);
        }
    }

    public void returnObject(T engine) {
        Validate.notNull(engine);
        try {
            this.objectPool.returnObject(engine);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get object from the pool", e);
        }
    }

    public final void setObjectPool(GenericObjectPool<T> objectPool) {
        Validate.notNull(objectPool);
        this.objectPool = objectPool;
    }

    public void destroy() throws Exception {
        LOG.debug("closing objectPool");
        this.objectPool.close();
    }
}

