/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response to the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAnalyzerResponse extends AccessAnalyzerResponse implements
        ToCopyableBuilder<GetAnalyzerResponse.Builder, GetAnalyzerResponse> {
    private static final SdkField<AnalyzerSummary> ANALYZER_FIELD = SdkField.<AnalyzerSummary> builder(MarshallingType.SDK_POJO)
            .memberName("analyzer").getter(getter(GetAnalyzerResponse::analyzer)).setter(setter(Builder::analyzer))
            .constructor(AnalyzerSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analyzer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYZER_FIELD));

    private final AnalyzerSummary analyzer;

    private GetAnalyzerResponse(BuilderImpl builder) {
        super(builder);
        this.analyzer = builder.analyzer;
    }

    /**
     * <p>
     * An <code>AnalyzerSummary</code> object that contains information about the analyzer.
     * </p>
     * 
     * @return An <code>AnalyzerSummary</code> object that contains information about the analyzer.
     */
    public AnalyzerSummary analyzer() {
        return analyzer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(analyzer());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAnalyzerResponse)) {
            return false;
        }
        GetAnalyzerResponse other = (GetAnalyzerResponse) obj;
        return Objects.equals(analyzer(), other.analyzer());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetAnalyzerResponse").add("Analyzer", analyzer()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "analyzer":
            return Optional.ofNullable(clazz.cast(analyzer()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAnalyzerResponse, T> g) {
        return obj -> g.apply((GetAnalyzerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AccessAnalyzerResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAnalyzerResponse> {
        /**
         * <p>
         * An <code>AnalyzerSummary</code> object that contains information about the analyzer.
         * </p>
         * 
         * @param analyzer
         *        An <code>AnalyzerSummary</code> object that contains information about the analyzer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyzer(AnalyzerSummary analyzer);

        /**
         * <p>
         * An <code>AnalyzerSummary</code> object that contains information about the analyzer.
         * </p>
         * This is a convenience that creates an instance of the {@link AnalyzerSummary.Builder} avoiding the need to
         * create one manually via {@link AnalyzerSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalyzerSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #analyzer(AnalyzerSummary)}.
         * 
         * @param analyzer
         *        a consumer that will call methods on {@link AnalyzerSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #analyzer(AnalyzerSummary)
         */
        default Builder analyzer(Consumer<AnalyzerSummary.Builder> analyzer) {
            return analyzer(AnalyzerSummary.builder().applyMutation(analyzer).build());
        }
    }

    static final class BuilderImpl extends AccessAnalyzerResponse.BuilderImpl implements Builder {
        private AnalyzerSummary analyzer;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAnalyzerResponse model) {
            super(model);
            analyzer(model.analyzer);
        }

        public final AnalyzerSummary.Builder getAnalyzer() {
            return analyzer != null ? analyzer.toBuilder() : null;
        }

        @Override
        public final Builder analyzer(AnalyzerSummary analyzer) {
            this.analyzer = analyzer;
            return this;
        }

        public final void setAnalyzer(AnalyzerSummary.BuilderImpl analyzer) {
            this.analyzer = analyzer != null ? analyzer.build() : null;
        }

        @Override
        public GetAnalyzerResponse build() {
            return new GetAnalyzerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
