/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An criterion statement in an archive rule. Each archive rule may have multiple criteria.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InlineArchiveRule implements SdkPojo, Serializable,
        ToCopyableBuilder<InlineArchiveRule.Builder, InlineArchiveRule> {
    private static final SdkField<Map<String, Criterion>> FILTER_FIELD = SdkField
            .<Map<String, Criterion>> builder(MarshallingType.MAP)
            .memberName("filter")
            .getter(getter(InlineArchiveRule::filter))
            .setter(setter(Builder::filter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Criterion> builder(MarshallingType.SDK_POJO)
                                            .constructor(Criterion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ruleName").getter(getter(InlineArchiveRule::ruleName)).setter(setter(Builder::ruleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(FILTER_FIELD, RULE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, Criterion> filter;

    private final String ruleName;

    private InlineArchiveRule(BuilderImpl builder) {
        this.filter = builder.filter;
        this.ruleName = builder.ruleName;
    }

    /**
     * Returns true if the Filter property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFilter() {
        return filter != null && !(filter instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The condition and values for a criterion.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilter()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The condition and values for a criterion.
     */
    public Map<String, Criterion> filter() {
        return filter;
    }

    /**
     * <p>
     * The name of the rule.
     * </p>
     * 
     * @return The name of the rule.
     */
    public String ruleName() {
        return ruleName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(ruleName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InlineArchiveRule)) {
            return false;
        }
        InlineArchiveRule other = (InlineArchiveRule) obj;
        return Objects.equals(filter(), other.filter()) && Objects.equals(ruleName(), other.ruleName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("InlineArchiveRule").add("Filter", filter()).add("RuleName", ruleName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "ruleName":
            return Optional.ofNullable(clazz.cast(ruleName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InlineArchiveRule, T> g) {
        return obj -> g.apply((InlineArchiveRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InlineArchiveRule> {
        /**
         * <p>
         * The condition and values for a criterion.
         * </p>
         * 
         * @param filter
         *        The condition and values for a criterion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Map<String, Criterion> filter);

        /**
         * <p>
         * The name of the rule.
         * </p>
         * 
         * @param ruleName
         *        The name of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleName(String ruleName);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, Criterion> filter = DefaultSdkAutoConstructMap.getInstance();

        private String ruleName;

        private BuilderImpl() {
        }

        private BuilderImpl(InlineArchiveRule model) {
            filter(model.filter);
            ruleName(model.ruleName);
        }

        public final Map<String, Criterion.Builder> getFilter() {
            return filter != null ? CollectionUtils.mapValues(filter, Criterion::toBuilder) : null;
        }

        @Override
        public final Builder filter(Map<String, Criterion> filter) {
            this.filter = FilterCriteriaMapCopier.copy(filter);
            return this;
        }

        public final void setFilter(Map<String, Criterion.BuilderImpl> filter) {
            this.filter = FilterCriteriaMapCopier.copyFromBuilder(filter);
        }

        public final String getRuleName() {
            return ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public InlineArchiveRule build() {
            return new InlineArchiveRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
