/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StepAdjustment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StepAdjustment> {
    private static final SdkField<Double> METRIC_INTERVAL_LOWER_BOUND_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MetricIntervalLowerBound").getter(StepAdjustment.getter(StepAdjustment::metricIntervalLowerBound)).setter(StepAdjustment.setter(Builder::metricIntervalLowerBound)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricIntervalLowerBound").build()}).build();
    private static final SdkField<Double> METRIC_INTERVAL_UPPER_BOUND_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MetricIntervalUpperBound").getter(StepAdjustment.getter(StepAdjustment::metricIntervalUpperBound)).setter(StepAdjustment.setter(Builder::metricIntervalUpperBound)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricIntervalUpperBound").build()}).build();
    private static final SdkField<Integer> SCALING_ADJUSTMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ScalingAdjustment").getter(StepAdjustment.getter(StepAdjustment::scalingAdjustment)).setter(StepAdjustment.setter(Builder::scalingAdjustment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingAdjustment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_INTERVAL_LOWER_BOUND_FIELD, METRIC_INTERVAL_UPPER_BOUND_FIELD, SCALING_ADJUSTMENT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Double metricIntervalLowerBound;
    private final Double metricIntervalUpperBound;
    private final Integer scalingAdjustment;

    private StepAdjustment(BuilderImpl builder) {
        this.metricIntervalLowerBound = builder.metricIntervalLowerBound;
        this.metricIntervalUpperBound = builder.metricIntervalUpperBound;
        this.scalingAdjustment = builder.scalingAdjustment;
    }

    public Double metricIntervalLowerBound() {
        return this.metricIntervalLowerBound;
    }

    public Double metricIntervalUpperBound() {
        return this.metricIntervalUpperBound;
    }

    public Integer scalingAdjustment() {
        return this.scalingAdjustment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metricIntervalLowerBound());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricIntervalUpperBound());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingAdjustment());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepAdjustment)) {
            return false;
        }
        StepAdjustment other = (StepAdjustment)obj;
        return Objects.equals(this.metricIntervalLowerBound(), other.metricIntervalLowerBound()) && Objects.equals(this.metricIntervalUpperBound(), other.metricIntervalUpperBound()) && Objects.equals(this.scalingAdjustment(), other.scalingAdjustment());
    }

    public String toString() {
        return ToString.builder((String)"StepAdjustment").add("MetricIntervalLowerBound", (Object)this.metricIntervalLowerBound()).add("MetricIntervalUpperBound", (Object)this.metricIntervalUpperBound()).add("ScalingAdjustment", (Object)this.scalingAdjustment()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricIntervalLowerBound": {
                return Optional.ofNullable(clazz.cast(this.metricIntervalLowerBound()));
            }
            case "MetricIntervalUpperBound": {
                return Optional.ofNullable(clazz.cast(this.metricIntervalUpperBound()));
            }
            case "ScalingAdjustment": {
                return Optional.ofNullable(clazz.cast(this.scalingAdjustment()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StepAdjustment, T> g) {
        return obj -> g.apply((StepAdjustment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double metricIntervalLowerBound;
        private Double metricIntervalUpperBound;
        private Integer scalingAdjustment;

        private BuilderImpl() {
        }

        private BuilderImpl(StepAdjustment model) {
            this.metricIntervalLowerBound(model.metricIntervalLowerBound);
            this.metricIntervalUpperBound(model.metricIntervalUpperBound);
            this.scalingAdjustment(model.scalingAdjustment);
        }

        public final Double getMetricIntervalLowerBound() {
            return this.metricIntervalLowerBound;
        }

        @Override
        public final Builder metricIntervalLowerBound(Double metricIntervalLowerBound) {
            this.metricIntervalLowerBound = metricIntervalLowerBound;
            return this;
        }

        public final void setMetricIntervalLowerBound(Double metricIntervalLowerBound) {
            this.metricIntervalLowerBound = metricIntervalLowerBound;
        }

        public final Double getMetricIntervalUpperBound() {
            return this.metricIntervalUpperBound;
        }

        @Override
        public final Builder metricIntervalUpperBound(Double metricIntervalUpperBound) {
            this.metricIntervalUpperBound = metricIntervalUpperBound;
            return this;
        }

        public final void setMetricIntervalUpperBound(Double metricIntervalUpperBound) {
            this.metricIntervalUpperBound = metricIntervalUpperBound;
        }

        public final Integer getScalingAdjustment() {
            return this.scalingAdjustment;
        }

        @Override
        public final Builder scalingAdjustment(Integer scalingAdjustment) {
            this.scalingAdjustment = scalingAdjustment;
            return this;
        }

        public final void setScalingAdjustment(Integer scalingAdjustment) {
            this.scalingAdjustment = scalingAdjustment;
        }

        public StepAdjustment build() {
            return new StepAdjustment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StepAdjustment> {
        public Builder metricIntervalLowerBound(Double var1);

        public Builder metricIntervalUpperBound(Double var1);

        public Builder scalingAdjustment(Integer var1);
    }
}

