/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a listener's Transport Layer Security (TLS) certificate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListenerTlsCertificate implements SdkPojo, Serializable,
        ToCopyableBuilder<ListenerTlsCertificate.Builder, ListenerTlsCertificate> {
    private static final SdkField<ListenerTlsAcmCertificate> ACM_FIELD = SdkField
            .<ListenerTlsAcmCertificate> builder(MarshallingType.SDK_POJO).memberName("acm")
            .getter(getter(ListenerTlsCertificate::acm)).setter(setter(Builder::acm))
            .constructor(ListenerTlsAcmCertificate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acm").build()).build();

    private static final SdkField<ListenerTlsFileCertificate> FILE_FIELD = SdkField
            .<ListenerTlsFileCertificate> builder(MarshallingType.SDK_POJO).memberName("file")
            .getter(getter(ListenerTlsCertificate::file)).setter(setter(Builder::file))
            .constructor(ListenerTlsFileCertificate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("file").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACM_FIELD, FILE_FIELD));

    private static final long serialVersionUID = 1L;

    private final ListenerTlsAcmCertificate acm;

    private final ListenerTlsFileCertificate file;

    private ListenerTlsCertificate(BuilderImpl builder) {
        this.acm = builder.acm;
        this.file = builder.file;
    }

    /**
     * <p>
     * A reference to an object that represents an AWS Certicate Manager (ACM) certificate.
     * </p>
     * 
     * @return A reference to an object that represents an AWS Certicate Manager (ACM) certificate.
     */
    public ListenerTlsAcmCertificate acm() {
        return acm;
    }

    /**
     * <p>
     * A reference to an object that represents a local file certificate.
     * </p>
     * 
     * @return A reference to an object that represents a local file certificate.
     */
    public ListenerTlsFileCertificate file() {
        return file;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(acm());
        hashCode = 31 * hashCode + Objects.hashCode(file());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListenerTlsCertificate)) {
            return false;
        }
        ListenerTlsCertificate other = (ListenerTlsCertificate) obj;
        return Objects.equals(acm(), other.acm()) && Objects.equals(file(), other.file());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListenerTlsCertificate").add("Acm", acm()).add("File", file()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "acm":
            return Optional.ofNullable(clazz.cast(acm()));
        case "file":
            return Optional.ofNullable(clazz.cast(file()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListenerTlsCertificate, T> g) {
        return obj -> g.apply((ListenerTlsCertificate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListenerTlsCertificate> {
        /**
         * <p>
         * A reference to an object that represents an AWS Certicate Manager (ACM) certificate.
         * </p>
         * 
         * @param acm
         *        A reference to an object that represents an AWS Certicate Manager (ACM) certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acm(ListenerTlsAcmCertificate acm);

        /**
         * <p>
         * A reference to an object that represents an AWS Certicate Manager (ACM) certificate.
         * </p>
         * This is a convenience that creates an instance of the {@link ListenerTlsAcmCertificate.Builder} avoiding the
         * need to create one manually via {@link ListenerTlsAcmCertificate#builder()}.
         *
         * When the {@link Consumer} completes, {@link ListenerTlsAcmCertificate.Builder#build()} is called immediately
         * and its result is passed to {@link #acm(ListenerTlsAcmCertificate)}.
         * 
         * @param acm
         *        a consumer that will call methods on {@link ListenerTlsAcmCertificate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #acm(ListenerTlsAcmCertificate)
         */
        default Builder acm(Consumer<ListenerTlsAcmCertificate.Builder> acm) {
            return acm(ListenerTlsAcmCertificate.builder().applyMutation(acm).build());
        }

        /**
         * <p>
         * A reference to an object that represents a local file certificate.
         * </p>
         * 
         * @param file
         *        A reference to an object that represents a local file certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder file(ListenerTlsFileCertificate file);

        /**
         * <p>
         * A reference to an object that represents a local file certificate.
         * </p>
         * This is a convenience that creates an instance of the {@link ListenerTlsFileCertificate.Builder} avoiding the
         * need to create one manually via {@link ListenerTlsFileCertificate#builder()}.
         *
         * When the {@link Consumer} completes, {@link ListenerTlsFileCertificate.Builder#build()} is called immediately
         * and its result is passed to {@link #file(ListenerTlsFileCertificate)}.
         * 
         * @param file
         *        a consumer that will call methods on {@link ListenerTlsFileCertificate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #file(ListenerTlsFileCertificate)
         */
        default Builder file(Consumer<ListenerTlsFileCertificate.Builder> file) {
            return file(ListenerTlsFileCertificate.builder().applyMutation(file).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ListenerTlsAcmCertificate acm;

        private ListenerTlsFileCertificate file;

        private BuilderImpl() {
        }

        private BuilderImpl(ListenerTlsCertificate model) {
            acm(model.acm);
            file(model.file);
        }

        public final ListenerTlsAcmCertificate.Builder getAcm() {
            return acm != null ? acm.toBuilder() : null;
        }

        @Override
        public final Builder acm(ListenerTlsAcmCertificate acm) {
            this.acm = acm;
            return this;
        }

        public final void setAcm(ListenerTlsAcmCertificate.BuilderImpl acm) {
            this.acm = acm != null ? acm.build() : null;
        }

        public final ListenerTlsFileCertificate.Builder getFile() {
            return file != null ? file.toBuilder() : null;
        }

        @Override
        public final Builder file(ListenerTlsFileCertificate file) {
            this.file = file;
            return this;
        }

        public final void setFile(ListenerTlsFileCertificate.BuilderImpl file) {
            this.file = file != null ? file.build() : null;
        }

        @Override
        public ListenerTlsCertificate build() {
            return new ListenerTlsCertificate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
