/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBackupPlanFromJsonResponse extends BackupResponse implements
        ToCopyableBuilder<GetBackupPlanFromJsonResponse.Builder, GetBackupPlanFromJsonResponse> {
    private static final SdkField<BackupPlan> BACKUP_PLAN_FIELD = SdkField.<BackupPlan> builder(MarshallingType.SDK_POJO)
            .memberName("BackupPlan").getter(getter(GetBackupPlanFromJsonResponse::backupPlan))
            .setter(setter(Builder::backupPlan)).constructor(BackupPlan::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlan").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_PLAN_FIELD));

    private final BackupPlan backupPlan;

    private GetBackupPlanFromJsonResponse(BuilderImpl builder) {
        super(builder);
        this.backupPlan = builder.backupPlan;
    }

    /**
     * <p>
     * Specifies the body of a backup plan. Includes a <code>BackupPlanName</code> and one or more sets of
     * <code>Rules</code>.
     * </p>
     * 
     * @return Specifies the body of a backup plan. Includes a <code>BackupPlanName</code> and one or more sets of
     *         <code>Rules</code>.
     */
    public BackupPlan backupPlan() {
        return backupPlan;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backupPlan());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBackupPlanFromJsonResponse)) {
            return false;
        }
        GetBackupPlanFromJsonResponse other = (GetBackupPlanFromJsonResponse) obj;
        return Objects.equals(backupPlan(), other.backupPlan());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetBackupPlanFromJsonResponse").add("BackupPlan", backupPlan()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupPlan":
            return Optional.ofNullable(clazz.cast(backupPlan()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBackupPlanFromJsonResponse, T> g) {
        return obj -> g.apply((GetBackupPlanFromJsonResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetBackupPlanFromJsonResponse> {
        /**
         * <p>
         * Specifies the body of a backup plan. Includes a <code>BackupPlanName</code> and one or more sets of
         * <code>Rules</code>.
         * </p>
         * 
         * @param backupPlan
         *        Specifies the body of a backup plan. Includes a <code>BackupPlanName</code> and one or more sets of
         *        <code>Rules</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlan(BackupPlan backupPlan);

        /**
         * <p>
         * Specifies the body of a backup plan. Includes a <code>BackupPlanName</code> and one or more sets of
         * <code>Rules</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link BackupPlan.Builder} avoiding the need to create
         * one manually via {@link BackupPlan#builder()}.
         *
         * When the {@link Consumer} completes, {@link BackupPlan.Builder#build()} is called immediately and its result
         * is passed to {@link #backupPlan(BackupPlan)}.
         * 
         * @param backupPlan
         *        a consumer that will call methods on {@link BackupPlan.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #backupPlan(BackupPlan)
         */
        default Builder backupPlan(Consumer<BackupPlan.Builder> backupPlan) {
            return backupPlan(BackupPlan.builder().applyMutation(backupPlan).build());
        }
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private BackupPlan backupPlan;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBackupPlanFromJsonResponse model) {
            super(model);
            backupPlan(model.backupPlan);
        }

        public final BackupPlan.Builder getBackupPlan() {
            return backupPlan != null ? backupPlan.toBuilder() : null;
        }

        @Override
        public final Builder backupPlan(BackupPlan backupPlan) {
            this.backupPlan = backupPlan;
            return this;
        }

        public final void setBackupPlan(BackupPlan.BuilderImpl backupPlan) {
            this.backupPlan = backupPlan != null ? backupPlan.build() : null;
        }

        @Override
        public GetBackupPlanFromJsonResponse build() {
            return new GetBackupPlanFromJsonResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
