/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains information about a backed-up resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProtectedResource implements SdkPojo, Serializable,
        ToCopyableBuilder<ProtectedResource.Builder, ProtectedResource> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(ProtectedResource::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(ProtectedResource::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<Instant> LAST_BACKUP_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastBackupTime").getter(getter(ProtectedResource::lastBackupTime))
            .setter(setter(Builder::lastBackupTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastBackupTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            RESOURCE_TYPE_FIELD, LAST_BACKUP_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resourceArn;

    private final String resourceType;

    private final Instant lastBackupTime;

    private ProtectedResource(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.resourceType = builder.resourceType;
        this.lastBackupTime = builder.lastBackupTime;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource
     * type.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the
     *         resource type.
     */
    public String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The type of AWS resource; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational
     * Database Service (Amazon RDS) database. For VSS Windows backups, the only supported resource type is Amazon EC2.
     * </p>
     * 
     * @return The type of AWS resource; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon
     *         Relational Database Service (Amazon RDS) database. For VSS Windows backups, the only supported resource
     *         type is Amazon EC2.
     */
    public String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The date and time a resource was last backed up, in Unix format and Coordinated Universal Time (UTC). The value
     * of <code>LastBackupTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents
     * Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time a resource was last backed up, in Unix format and Coordinated Universal Time (UTC). The
     *         value of <code>LastBackupTime</code> is accurate to milliseconds. For example, the value 1516925490.087
     *         represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public Instant lastBackupTime() {
        return lastBackupTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(lastBackupTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectedResource)) {
            return false;
        }
        ProtectedResource other = (ProtectedResource) obj;
        return Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(lastBackupTime(), other.lastBackupTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ProtectedResource").add("ResourceArn", resourceArn()).add("ResourceType", resourceType())
                .add("LastBackupTime", lastBackupTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "LastBackupTime":
            return Optional.ofNullable(clazz.cast(lastBackupTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProtectedResource, T> g) {
        return obj -> g.apply((ProtectedResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProtectedResource> {
        /**
         * <p>
         * An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the
         * resource type.
         * </p>
         * 
         * @param resourceArn
         *        An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on
         *        the resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The type of AWS resource; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon
         * Relational Database Service (Amazon RDS) database. For VSS Windows backups, the only supported resource type
         * is Amazon EC2.
         * </p>
         * 
         * @param resourceType
         *        The type of AWS resource; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon
         *        Relational Database Service (Amazon RDS) database. For VSS Windows backups, the only supported
         *        resource type is Amazon EC2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The date and time a resource was last backed up, in Unix format and Coordinated Universal Time (UTC). The
         * value of <code>LastBackupTime</code> is accurate to milliseconds. For example, the value 1516925490.087
         * represents Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param lastBackupTime
         *        The date and time a resource was last backed up, in Unix format and Coordinated Universal Time (UTC).
         *        The value of <code>LastBackupTime</code> is accurate to milliseconds. For example, the value
         *        1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastBackupTime(Instant lastBackupTime);
    }

    static final class BuilderImpl implements Builder {
        private String resourceArn;

        private String resourceType;

        private Instant lastBackupTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ProtectedResource model) {
            resourceArn(model.resourceArn);
            resourceType(model.resourceType);
            lastBackupTime(model.lastBackupTime);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Instant getLastBackupTime() {
            return lastBackupTime;
        }

        @Override
        public final Builder lastBackupTime(Instant lastBackupTime) {
            this.lastBackupTime = lastBackupTime;
            return this;
        }

        public final void setLastBackupTime(Instant lastBackupTime) {
            this.lastBackupTime = lastBackupTime;
        }

        @Override
        public ProtectedResource build() {
            return new ProtectedResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
