/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for a field-level encryption content type-profile mapping.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContentTypeProfileConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ContentTypeProfileConfig.Builder, ContentTypeProfileConfig> {
    private static final SdkField<Boolean> FORWARD_WHEN_CONTENT_TYPE_IS_UNKNOWN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ForwardWhenContentTypeIsUnknown")
            .getter(getter(ContentTypeProfileConfig::forwardWhenContentTypeIsUnknown))
            .setter(setter(Builder::forwardWhenContentTypeIsUnknown))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForwardWhenContentTypeIsUnknown")
                    .unmarshallLocationName("ForwardWhenContentTypeIsUnknown").build()).build();

    private static final SdkField<ContentTypeProfiles> CONTENT_TYPE_PROFILES_FIELD = SdkField
            .<ContentTypeProfiles> builder(MarshallingType.SDK_POJO)
            .memberName("ContentTypeProfiles")
            .getter(getter(ContentTypeProfileConfig::contentTypeProfiles))
            .setter(setter(Builder::contentTypeProfiles))
            .constructor(ContentTypeProfiles::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentTypeProfiles")
                    .unmarshallLocationName("ContentTypeProfiles").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            FORWARD_WHEN_CONTENT_TYPE_IS_UNKNOWN_FIELD, CONTENT_TYPE_PROFILES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean forwardWhenContentTypeIsUnknown;

    private final ContentTypeProfiles contentTypeProfiles;

    private ContentTypeProfileConfig(BuilderImpl builder) {
        this.forwardWhenContentTypeIsUnknown = builder.forwardWhenContentTypeIsUnknown;
        this.contentTypeProfiles = builder.contentTypeProfiles;
    }

    /**
     * <p>
     * The setting in a field-level encryption content type-profile mapping that specifies what to do when an unknown
     * content type is provided for the profile. If true, content is forwarded without being encrypted when the content
     * type is unknown. If false (the default), an error is returned when the content type is unknown.
     * </p>
     * 
     * @return The setting in a field-level encryption content type-profile mapping that specifies what to do when an
     *         unknown content type is provided for the profile. If true, content is forwarded without being encrypted
     *         when the content type is unknown. If false (the default), an error is returned when the content type is
     *         unknown.
     */
    public Boolean forwardWhenContentTypeIsUnknown() {
        return forwardWhenContentTypeIsUnknown;
    }

    /**
     * <p>
     * The configuration for a field-level encryption content type-profile.
     * </p>
     * 
     * @return The configuration for a field-level encryption content type-profile.
     */
    public ContentTypeProfiles contentTypeProfiles() {
        return contentTypeProfiles;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(forwardWhenContentTypeIsUnknown());
        hashCode = 31 * hashCode + Objects.hashCode(contentTypeProfiles());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentTypeProfileConfig)) {
            return false;
        }
        ContentTypeProfileConfig other = (ContentTypeProfileConfig) obj;
        return Objects.equals(forwardWhenContentTypeIsUnknown(), other.forwardWhenContentTypeIsUnknown())
                && Objects.equals(contentTypeProfiles(), other.contentTypeProfiles());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ContentTypeProfileConfig")
                .add("ForwardWhenContentTypeIsUnknown", forwardWhenContentTypeIsUnknown())
                .add("ContentTypeProfiles", contentTypeProfiles()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ForwardWhenContentTypeIsUnknown":
            return Optional.ofNullable(clazz.cast(forwardWhenContentTypeIsUnknown()));
        case "ContentTypeProfiles":
            return Optional.ofNullable(clazz.cast(contentTypeProfiles()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContentTypeProfileConfig, T> g) {
        return obj -> g.apply((ContentTypeProfileConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContentTypeProfileConfig> {
        /**
         * <p>
         * The setting in a field-level encryption content type-profile mapping that specifies what to do when an
         * unknown content type is provided for the profile. If true, content is forwarded without being encrypted when
         * the content type is unknown. If false (the default), an error is returned when the content type is unknown.
         * </p>
         * 
         * @param forwardWhenContentTypeIsUnknown
         *        The setting in a field-level encryption content type-profile mapping that specifies what to do when an
         *        unknown content type is provided for the profile. If true, content is forwarded without being
         *        encrypted when the content type is unknown. If false (the default), an error is returned when the
         *        content type is unknown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forwardWhenContentTypeIsUnknown(Boolean forwardWhenContentTypeIsUnknown);

        /**
         * <p>
         * The configuration for a field-level encryption content type-profile.
         * </p>
         * 
         * @param contentTypeProfiles
         *        The configuration for a field-level encryption content type-profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentTypeProfiles(ContentTypeProfiles contentTypeProfiles);

        /**
         * <p>
         * The configuration for a field-level encryption content type-profile.
         * </p>
         * This is a convenience that creates an instance of the {@link ContentTypeProfiles.Builder} avoiding the need
         * to create one manually via {@link ContentTypeProfiles#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContentTypeProfiles.Builder#build()} is called immediately and
         * its result is passed to {@link #contentTypeProfiles(ContentTypeProfiles)}.
         * 
         * @param contentTypeProfiles
         *        a consumer that will call methods on {@link ContentTypeProfiles.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contentTypeProfiles(ContentTypeProfiles)
         */
        default Builder contentTypeProfiles(Consumer<ContentTypeProfiles.Builder> contentTypeProfiles) {
            return contentTypeProfiles(ContentTypeProfiles.builder().applyMutation(contentTypeProfiles).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean forwardWhenContentTypeIsUnknown;

        private ContentTypeProfiles contentTypeProfiles;

        private BuilderImpl() {
        }

        private BuilderImpl(ContentTypeProfileConfig model) {
            forwardWhenContentTypeIsUnknown(model.forwardWhenContentTypeIsUnknown);
            contentTypeProfiles(model.contentTypeProfiles);
        }

        public final Boolean getForwardWhenContentTypeIsUnknown() {
            return forwardWhenContentTypeIsUnknown;
        }

        @Override
        public final Builder forwardWhenContentTypeIsUnknown(Boolean forwardWhenContentTypeIsUnknown) {
            this.forwardWhenContentTypeIsUnknown = forwardWhenContentTypeIsUnknown;
            return this;
        }

        public final void setForwardWhenContentTypeIsUnknown(Boolean forwardWhenContentTypeIsUnknown) {
            this.forwardWhenContentTypeIsUnknown = forwardWhenContentTypeIsUnknown;
        }

        public final ContentTypeProfiles.Builder getContentTypeProfiles() {
            return contentTypeProfiles != null ? contentTypeProfiles.toBuilder() : null;
        }

        @Override
        public final Builder contentTypeProfiles(ContentTypeProfiles contentTypeProfiles) {
            this.contentTypeProfiles = contentTypeProfiles;
            return this;
        }

        public final void setContentTypeProfiles(ContentTypeProfiles.BuilderImpl contentTypeProfiles) {
            this.contentTypeProfiles = contentTypeProfiles != null ? contentTypeProfiles.build() : null;
        }

        @Override
        public ContentTypeProfileConfig build() {
            return new ContentTypeProfileConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
