/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCachePolicyRequest extends CloudFrontRequest implements
        ToCopyableBuilder<CreateCachePolicyRequest.Builder, CreateCachePolicyRequest> {
    private static final SdkField<CachePolicyConfig> CACHE_POLICY_CONFIG_FIELD = SdkField
            .<CachePolicyConfig> builder(MarshallingType.SDK_POJO)
            .memberName("CachePolicyConfig")
            .getter(getter(CreateCachePolicyRequest::cachePolicyConfig))
            .setter(setter(Builder::cachePolicyConfig))
            .constructor(CachePolicyConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CachePolicyConfig")
                    .unmarshallLocationName("CachePolicyConfig").build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_POLICY_CONFIG_FIELD));

    private final CachePolicyConfig cachePolicyConfig;

    private CreateCachePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.cachePolicyConfig = builder.cachePolicyConfig;
    }

    /**
     * <p>
     * A cache policy configuration.
     * </p>
     * 
     * @return A cache policy configuration.
     */
    public CachePolicyConfig cachePolicyConfig() {
        return cachePolicyConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cachePolicyConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCachePolicyRequest)) {
            return false;
        }
        CreateCachePolicyRequest other = (CreateCachePolicyRequest) obj;
        return Objects.equals(cachePolicyConfig(), other.cachePolicyConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateCachePolicyRequest").add("CachePolicyConfig", cachePolicyConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CachePolicyConfig":
            return Optional.ofNullable(clazz.cast(cachePolicyConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCachePolicyRequest, T> g) {
        return obj -> g.apply((CreateCachePolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateCachePolicyRequest> {
        /**
         * <p>
         * A cache policy configuration.
         * </p>
         * 
         * @param cachePolicyConfig
         *        A cache policy configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cachePolicyConfig(CachePolicyConfig cachePolicyConfig);

        /**
         * <p>
         * A cache policy configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link CachePolicyConfig.Builder} avoiding the need to
         * create one manually via {@link CachePolicyConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link CachePolicyConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #cachePolicyConfig(CachePolicyConfig)}.
         * 
         * @param cachePolicyConfig
         *        a consumer that will call methods on {@link CachePolicyConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cachePolicyConfig(CachePolicyConfig)
         */
        default Builder cachePolicyConfig(Consumer<CachePolicyConfig.Builder> cachePolicyConfig) {
            return cachePolicyConfig(CachePolicyConfig.builder().applyMutation(cachePolicyConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private CachePolicyConfig cachePolicyConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCachePolicyRequest model) {
            super(model);
            cachePolicyConfig(model.cachePolicyConfig);
        }

        public final CachePolicyConfig.Builder getCachePolicyConfig() {
            return cachePolicyConfig != null ? cachePolicyConfig.toBuilder() : null;
        }

        @Override
        public final Builder cachePolicyConfig(CachePolicyConfig cachePolicyConfig) {
            this.cachePolicyConfig = cachePolicyConfig;
            return this;
        }

        public final void setCachePolicyConfig(CachePolicyConfig.BuilderImpl cachePolicyConfig) {
            this.cachePolicyConfig = cachePolicyConfig != null ? cachePolicyConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCachePolicyRequest build() {
            return new CreateCachePolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
