/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCachePolicyResponse extends CloudFrontResponse implements
        ToCopyableBuilder<CreateCachePolicyResponse.Builder, CreateCachePolicyResponse> {
    private static final SdkField<CachePolicy> CACHE_POLICY_FIELD = SdkField
            .<CachePolicy> builder(MarshallingType.SDK_POJO)
            .memberName("CachePolicy")
            .getter(getter(CreateCachePolicyResponse::cachePolicy))
            .setter(setter(Builder::cachePolicy))
            .constructor(CachePolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CachePolicy")
                    .unmarshallLocationName("CachePolicy").build(), PayloadTrait.create()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Location")
            .getter(getter(CreateCachePolicyResponse::location))
            .setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Location")
                    .unmarshallLocationName("Location").build()).build();

    private static final SdkField<String> E_TAG_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ETag")
            .getter(getter(CreateCachePolicyResponse::eTag))
            .setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_POLICY_FIELD,
            LOCATION_FIELD, E_TAG_FIELD));

    private final CachePolicy cachePolicy;

    private final String location;

    private final String eTag;

    private CreateCachePolicyResponse(BuilderImpl builder) {
        super(builder);
        this.cachePolicy = builder.cachePolicy;
        this.location = builder.location;
        this.eTag = builder.eTag;
    }

    /**
     * <p>
     * A cache policy.
     * </p>
     * 
     * @return A cache policy.
     */
    public CachePolicy cachePolicy() {
        return cachePolicy;
    }

    /**
     * <p>
     * The fully qualified URI of the cache policy just created.
     * </p>
     * 
     * @return The fully qualified URI of the cache policy just created.
     */
    public String location() {
        return location;
    }

    /**
     * <p>
     * The current version of the cache policy.
     * </p>
     * 
     * @return The current version of the cache policy.
     */
    public String eTag() {
        return eTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cachePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCachePolicyResponse)) {
            return false;
        }
        CreateCachePolicyResponse other = (CreateCachePolicyResponse) obj;
        return Objects.equals(cachePolicy(), other.cachePolicy()) && Objects.equals(location(), other.location())
                && Objects.equals(eTag(), other.eTag());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateCachePolicyResponse").add("CachePolicy", cachePolicy()).add("Location", location())
                .add("ETag", eTag()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CachePolicy":
            return Optional.ofNullable(clazz.cast(cachePolicy()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCachePolicyResponse, T> g) {
        return obj -> g.apply((CreateCachePolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateCachePolicyResponse> {
        /**
         * <p>
         * A cache policy.
         * </p>
         * 
         * @param cachePolicy
         *        A cache policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cachePolicy(CachePolicy cachePolicy);

        /**
         * <p>
         * A cache policy.
         * </p>
         * This is a convenience that creates an instance of the {@link CachePolicy.Builder} avoiding the need to create
         * one manually via {@link CachePolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link CachePolicy.Builder#build()} is called immediately and its result
         * is passed to {@link #cachePolicy(CachePolicy)}.
         * 
         * @param cachePolicy
         *        a consumer that will call methods on {@link CachePolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cachePolicy(CachePolicy)
         */
        default Builder cachePolicy(Consumer<CachePolicy.Builder> cachePolicy) {
            return cachePolicy(CachePolicy.builder().applyMutation(cachePolicy).build());
        }

        /**
         * <p>
         * The fully qualified URI of the cache policy just created.
         * </p>
         * 
         * @param location
         *        The fully qualified URI of the cache policy just created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * The current version of the cache policy.
         * </p>
         * 
         * @param eTag
         *        The current version of the cache policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private CachePolicy cachePolicy;

        private String location;

        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCachePolicyResponse model) {
            super(model);
            cachePolicy(model.cachePolicy);
            location(model.location);
            eTag(model.eTag);
        }

        public final CachePolicy.Builder getCachePolicy() {
            return cachePolicy != null ? cachePolicy.toBuilder() : null;
        }

        @Override
        public final Builder cachePolicy(CachePolicy cachePolicy) {
            this.cachePolicy = cachePolicy;
            return this;
        }

        public final void setCachePolicy(CachePolicy.BuilderImpl cachePolicy) {
            this.cachePolicy = cachePolicy != null ? cachePolicy.build() : null;
        }

        public final String getLocation() {
            return location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getETag() {
            return eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public CreateCachePolicyResponse build() {
            return new CreateCachePolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
