/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMonitoringSubscriptionRequest extends CloudFrontRequest implements
        ToCopyableBuilder<CreateMonitoringSubscriptionRequest.Builder, CreateMonitoringSubscriptionRequest> {
    private static final SdkField<String> DISTRIBUTION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DistributionId")
            .getter(getter(CreateMonitoringSubscriptionRequest::distributionId))
            .setter(setter(Builder::distributionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DistributionId")
                    .unmarshallLocationName("DistributionId").build()).build();

    private static final SdkField<MonitoringSubscription> MONITORING_SUBSCRIPTION_FIELD = SdkField
            .<MonitoringSubscription> builder(MarshallingType.SDK_POJO)
            .memberName("MonitoringSubscription")
            .getter(getter(CreateMonitoringSubscriptionRequest::monitoringSubscription))
            .setter(setter(Builder::monitoringSubscription))
            .constructor(MonitoringSubscription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringSubscription")
                    .unmarshallLocationName("MonitoringSubscription").build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTRIBUTION_ID_FIELD,
            MONITORING_SUBSCRIPTION_FIELD));

    private final String distributionId;

    private final MonitoringSubscription monitoringSubscription;

    private CreateMonitoringSubscriptionRequest(BuilderImpl builder) {
        super(builder);
        this.distributionId = builder.distributionId;
        this.monitoringSubscription = builder.monitoringSubscription;
    }

    /**
     * <p>
     * The ID of the distribution that you are enabling metrics for.
     * </p>
     * 
     * @return The ID of the distribution that you are enabling metrics for.
     */
    public String distributionId() {
        return distributionId;
    }

    /**
     * <p>
     * A monitoring subscription. This structure contains information about whether additional CloudWatch metrics are
     * enabled for a given CloudFront distribution.
     * </p>
     * 
     * @return A monitoring subscription. This structure contains information about whether additional CloudWatch
     *         metrics are enabled for a given CloudFront distribution.
     */
    public MonitoringSubscription monitoringSubscription() {
        return monitoringSubscription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(distributionId());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringSubscription());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMonitoringSubscriptionRequest)) {
            return false;
        }
        CreateMonitoringSubscriptionRequest other = (CreateMonitoringSubscriptionRequest) obj;
        return Objects.equals(distributionId(), other.distributionId())
                && Objects.equals(monitoringSubscription(), other.monitoringSubscription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateMonitoringSubscriptionRequest").add("DistributionId", distributionId())
                .add("MonitoringSubscription", monitoringSubscription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DistributionId":
            return Optional.ofNullable(clazz.cast(distributionId()));
        case "MonitoringSubscription":
            return Optional.ofNullable(clazz.cast(monitoringSubscription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMonitoringSubscriptionRequest, T> g) {
        return obj -> g.apply((CreateMonitoringSubscriptionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateMonitoringSubscriptionRequest> {
        /**
         * <p>
         * The ID of the distribution that you are enabling metrics for.
         * </p>
         * 
         * @param distributionId
         *        The ID of the distribution that you are enabling metrics for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionId(String distributionId);

        /**
         * <p>
         * A monitoring subscription. This structure contains information about whether additional CloudWatch metrics
         * are enabled for a given CloudFront distribution.
         * </p>
         * 
         * @param monitoringSubscription
         *        A monitoring subscription. This structure contains information about whether additional CloudWatch
         *        metrics are enabled for a given CloudFront distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringSubscription(MonitoringSubscription monitoringSubscription);

        /**
         * <p>
         * A monitoring subscription. This structure contains information about whether additional CloudWatch metrics
         * are enabled for a given CloudFront distribution.
         * </p>
         * This is a convenience that creates an instance of the {@link MonitoringSubscription.Builder} avoiding the
         * need to create one manually via {@link MonitoringSubscription#builder()}.
         *
         * When the {@link Consumer} completes, {@link MonitoringSubscription.Builder#build()} is called immediately and
         * its result is passed to {@link #monitoringSubscription(MonitoringSubscription)}.
         * 
         * @param monitoringSubscription
         *        a consumer that will call methods on {@link MonitoringSubscription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitoringSubscription(MonitoringSubscription)
         */
        default Builder monitoringSubscription(Consumer<MonitoringSubscription.Builder> monitoringSubscription) {
            return monitoringSubscription(MonitoringSubscription.builder().applyMutation(monitoringSubscription).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private String distributionId;

        private MonitoringSubscription monitoringSubscription;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMonitoringSubscriptionRequest model) {
            super(model);
            distributionId(model.distributionId);
            monitoringSubscription(model.monitoringSubscription);
        }

        public final String getDistributionId() {
            return distributionId;
        }

        @Override
        public final Builder distributionId(String distributionId) {
            this.distributionId = distributionId;
            return this;
        }

        public final void setDistributionId(String distributionId) {
            this.distributionId = distributionId;
        }

        public final MonitoringSubscription.Builder getMonitoringSubscription() {
            return monitoringSubscription != null ? monitoringSubscription.toBuilder() : null;
        }

        @Override
        public final Builder monitoringSubscription(MonitoringSubscription monitoringSubscription) {
            this.monitoringSubscription = monitoringSubscription;
            return this;
        }

        public final void setMonitoringSubscription(MonitoringSubscription.BuilderImpl monitoringSubscription) {
            this.monitoringSubscription = monitoringSubscription != null ? monitoringSubscription.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMonitoringSubscriptionRequest build() {
            return new CreateMonitoringSubscriptionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
