/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex data type for field-level encryption profiles.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FieldLevelEncryptionProfile implements SdkPojo, Serializable,
        ToCopyableBuilder<FieldLevelEncryptionProfile.Builder, FieldLevelEncryptionProfile> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(FieldLevelEncryptionProfile::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime")
            .getter(getter(FieldLevelEncryptionProfile::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime")
                    .unmarshallLocationName("LastModifiedTime").build()).build();

    private static final SdkField<FieldLevelEncryptionProfileConfig> FIELD_LEVEL_ENCRYPTION_PROFILE_CONFIG_FIELD = SdkField
            .<FieldLevelEncryptionProfileConfig> builder(MarshallingType.SDK_POJO)
            .memberName("FieldLevelEncryptionProfileConfig")
            .getter(getter(FieldLevelEncryptionProfile::fieldLevelEncryptionProfileConfig))
            .setter(setter(Builder::fieldLevelEncryptionProfileConfig))
            .constructor(FieldLevelEncryptionProfileConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldLevelEncryptionProfileConfig")
                    .unmarshallLocationName("FieldLevelEncryptionProfileConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            LAST_MODIFIED_TIME_FIELD, FIELD_LEVEL_ENCRYPTION_PROFILE_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final Instant lastModifiedTime;

    private final FieldLevelEncryptionProfileConfig fieldLevelEncryptionProfileConfig;

    private FieldLevelEncryptionProfile(BuilderImpl builder) {
        this.id = builder.id;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.fieldLevelEncryptionProfileConfig = builder.fieldLevelEncryptionProfileConfig;
    }

    /**
     * <p>
     * The ID for a field-level encryption profile configuration which includes a set of profiles that specify certain
     * selected data fields to be encrypted by specific public keys.
     * </p>
     * 
     * @return The ID for a field-level encryption profile configuration which includes a set of profiles that specify
     *         certain selected data fields to be encrypted by specific public keys.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The last time the field-level encryption profile was updated.
     * </p>
     * 
     * @return The last time the field-level encryption profile was updated.
     */
    public Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * A complex data type that includes the profile name and the encryption entities for the field-level encryption
     * profile.
     * </p>
     * 
     * @return A complex data type that includes the profile name and the encryption entities for the field-level
     *         encryption profile.
     */
    public FieldLevelEncryptionProfileConfig fieldLevelEncryptionProfileConfig() {
        return fieldLevelEncryptionProfileConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(fieldLevelEncryptionProfileConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldLevelEncryptionProfile)) {
            return false;
        }
        FieldLevelEncryptionProfile other = (FieldLevelEncryptionProfile) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(fieldLevelEncryptionProfileConfig(), other.fieldLevelEncryptionProfileConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("FieldLevelEncryptionProfile").add("Id", id()).add("LastModifiedTime", lastModifiedTime())
                .add("FieldLevelEncryptionProfileConfig", fieldLevelEncryptionProfileConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "FieldLevelEncryptionProfileConfig":
            return Optional.ofNullable(clazz.cast(fieldLevelEncryptionProfileConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FieldLevelEncryptionProfile, T> g) {
        return obj -> g.apply((FieldLevelEncryptionProfile) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FieldLevelEncryptionProfile> {
        /**
         * <p>
         * The ID for a field-level encryption profile configuration which includes a set of profiles that specify
         * certain selected data fields to be encrypted by specific public keys.
         * </p>
         * 
         * @param id
         *        The ID for a field-level encryption profile configuration which includes a set of profiles that
         *        specify certain selected data fields to be encrypted by specific public keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The last time the field-level encryption profile was updated.
         * </p>
         * 
         * @param lastModifiedTime
         *        The last time the field-level encryption profile was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * A complex data type that includes the profile name and the encryption entities for the field-level encryption
         * profile.
         * </p>
         * 
         * @param fieldLevelEncryptionProfileConfig
         *        A complex data type that includes the profile name and the encryption entities for the field-level
         *        encryption profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldLevelEncryptionProfileConfig(FieldLevelEncryptionProfileConfig fieldLevelEncryptionProfileConfig);

        /**
         * <p>
         * A complex data type that includes the profile name and the encryption entities for the field-level encryption
         * profile.
         * </p>
         * This is a convenience that creates an instance of the {@link FieldLevelEncryptionProfileConfig.Builder}
         * avoiding the need to create one manually via {@link FieldLevelEncryptionProfileConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link FieldLevelEncryptionProfileConfig.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #fieldLevelEncryptionProfileConfig(FieldLevelEncryptionProfileConfig)}.
         * 
         * @param fieldLevelEncryptionProfileConfig
         *        a consumer that will call methods on {@link FieldLevelEncryptionProfileConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldLevelEncryptionProfileConfig(FieldLevelEncryptionProfileConfig)
         */
        default Builder fieldLevelEncryptionProfileConfig(
                Consumer<FieldLevelEncryptionProfileConfig.Builder> fieldLevelEncryptionProfileConfig) {
            return fieldLevelEncryptionProfileConfig(FieldLevelEncryptionProfileConfig.builder()
                    .applyMutation(fieldLevelEncryptionProfileConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private Instant lastModifiedTime;

        private FieldLevelEncryptionProfileConfig fieldLevelEncryptionProfileConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(FieldLevelEncryptionProfile model) {
            id(model.id);
            lastModifiedTime(model.lastModifiedTime);
            fieldLevelEncryptionProfileConfig(model.fieldLevelEncryptionProfileConfig);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final FieldLevelEncryptionProfileConfig.Builder getFieldLevelEncryptionProfileConfig() {
            return fieldLevelEncryptionProfileConfig != null ? fieldLevelEncryptionProfileConfig.toBuilder() : null;
        }

        @Override
        public final Builder fieldLevelEncryptionProfileConfig(FieldLevelEncryptionProfileConfig fieldLevelEncryptionProfileConfig) {
            this.fieldLevelEncryptionProfileConfig = fieldLevelEncryptionProfileConfig;
            return this;
        }

        public final void setFieldLevelEncryptionProfileConfig(
                FieldLevelEncryptionProfileConfig.BuilderImpl fieldLevelEncryptionProfileConfig) {
            this.fieldLevelEncryptionProfileConfig = fieldLevelEncryptionProfileConfig != null ? fieldLevelEncryptionProfileConfig
                    .build() : null;
        }

        @Override
        public FieldLevelEncryptionProfile build() {
            return new FieldLevelEncryptionProfile(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
