/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The returned result of the corresponding request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDistributionConfigResponse extends CloudFrontResponse implements
        ToCopyableBuilder<GetDistributionConfigResponse.Builder, GetDistributionConfigResponse> {
    private static final SdkField<DistributionConfig> DISTRIBUTION_CONFIG_FIELD = SdkField
            .<DistributionConfig> builder(MarshallingType.SDK_POJO)
            .memberName("DistributionConfig")
            .getter(getter(GetDistributionConfigResponse::distributionConfig))
            .setter(setter(Builder::distributionConfig))
            .constructor(DistributionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistributionConfig")
                    .unmarshallLocationName("DistributionConfig").build(), PayloadTrait.create()).build();

    private static final SdkField<String> E_TAG_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ETag")
            .getter(getter(GetDistributionConfigResponse::eTag))
            .setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTRIBUTION_CONFIG_FIELD,
            E_TAG_FIELD));

    private final DistributionConfig distributionConfig;

    private final String eTag;

    private GetDistributionConfigResponse(BuilderImpl builder) {
        super(builder);
        this.distributionConfig = builder.distributionConfig;
        this.eTag = builder.eTag;
    }

    /**
     * <p>
     * The distribution's configuration information.
     * </p>
     * 
     * @return The distribution's configuration information.
     */
    public DistributionConfig distributionConfig() {
        return distributionConfig;
    }

    /**
     * <p>
     * The current version of the configuration. For example: <code>E2QWRUHAPOMQZL</code>.
     * </p>
     * 
     * @return The current version of the configuration. For example: <code>E2QWRUHAPOMQZL</code>.
     */
    public String eTag() {
        return eTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(distributionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDistributionConfigResponse)) {
            return false;
        }
        GetDistributionConfigResponse other = (GetDistributionConfigResponse) obj;
        return Objects.equals(distributionConfig(), other.distributionConfig()) && Objects.equals(eTag(), other.eTag());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetDistributionConfigResponse").add("DistributionConfig", distributionConfig())
                .add("ETag", eTag()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DistributionConfig":
            return Optional.ofNullable(clazz.cast(distributionConfig()));
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDistributionConfigResponse, T> g) {
        return obj -> g.apply((GetDistributionConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDistributionConfigResponse> {
        /**
         * <p>
         * The distribution's configuration information.
         * </p>
         * 
         * @param distributionConfig
         *        The distribution's configuration information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionConfig(DistributionConfig distributionConfig);

        /**
         * <p>
         * The distribution's configuration information.
         * </p>
         * This is a convenience that creates an instance of the {@link DistributionConfig.Builder} avoiding the need to
         * create one manually via {@link DistributionConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link DistributionConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #distributionConfig(DistributionConfig)}.
         * 
         * @param distributionConfig
         *        a consumer that will call methods on {@link DistributionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #distributionConfig(DistributionConfig)
         */
        default Builder distributionConfig(Consumer<DistributionConfig.Builder> distributionConfig) {
            return distributionConfig(DistributionConfig.builder().applyMutation(distributionConfig).build());
        }

        /**
         * <p>
         * The current version of the configuration. For example: <code>E2QWRUHAPOMQZL</code>.
         * </p>
         * 
         * @param eTag
         *        The current version of the configuration. For example: <code>E2QWRUHAPOMQZL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private DistributionConfig distributionConfig;

        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDistributionConfigResponse model) {
            super(model);
            distributionConfig(model.distributionConfig);
            eTag(model.eTag);
        }

        public final DistributionConfig.Builder getDistributionConfig() {
            return distributionConfig != null ? distributionConfig.toBuilder() : null;
        }

        @Override
        public final Builder distributionConfig(DistributionConfig distributionConfig) {
            this.distributionConfig = distributionConfig;
            return this;
        }

        public final void setDistributionConfig(DistributionConfig.BuilderImpl distributionConfig) {
            this.distributionConfig = distributionConfig != null ? distributionConfig.build() : null;
        }

        public final String getETag() {
            return eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public GetDistributionConfigResponse build() {
            return new GetDistributionConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
