/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the Amazon Kinesis data stream where you are sending real-time log data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KinesisStreamConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<KinesisStreamConfig.Builder, KinesisStreamConfig> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RoleARN")
            .getter(getter(KinesisStreamConfig::roleARN))
            .setter(setter(Builder::roleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN")
                    .unmarshallLocationName("RoleARN").build()).build();

    private static final SdkField<String> STREAM_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StreamARN")
            .getter(getter(KinesisStreamConfig::streamARN))
            .setter(setter(Builder::streamARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN")
                    .unmarshallLocationName("StreamARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD,
            STREAM_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String roleARN;

    private final String streamARN;

    private KinesisStreamConfig(BuilderImpl builder) {
        this.roleARN = builder.roleARN;
        this.streamARN = builder.streamARN;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that CloudFront can use to
     * send real-time log data to your Kinesis data stream.
     * </p>
     * <p>
     * For more information the IAM role, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-iam-role"
     * >Real-time log configuration IAM role</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that CloudFront can
     *         use to send real-time log data to your Kinesis data stream.</p>
     *         <p>
     *         For more information the IAM role, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-iam-role"
     *         >Real-time log configuration IAM role</a> in the <i>Amazon CloudFront Developer Guide</i>.
     */
    public String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Kinesis data stream where you are sending real-time log data.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Kinesis data stream where you are sending real-time log data.
     */
    public String streamARN() {
        return streamARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(streamARN());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisStreamConfig)) {
            return false;
        }
        KinesisStreamConfig other = (KinesisStreamConfig) obj;
        return Objects.equals(roleARN(), other.roleARN()) && Objects.equals(streamARN(), other.streamARN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("KinesisStreamConfig").add("RoleARN", roleARN()).add("StreamARN", streamARN()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoleARN":
            return Optional.ofNullable(clazz.cast(roleARN()));
        case "StreamARN":
            return Optional.ofNullable(clazz.cast(streamARN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KinesisStreamConfig, T> g) {
        return obj -> g.apply((KinesisStreamConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KinesisStreamConfig> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that CloudFront can use to
         * send real-time log data to your Kinesis data stream.
         * </p>
         * <p>
         * For more information the IAM role, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-iam-role"
         * >Real-time log configuration IAM role</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param roleARN
         *        The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that CloudFront can
         *        use to send real-time log data to your Kinesis data stream.</p>
         *        <p>
         *        For more information the IAM role, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-iam-role"
         *        >Real-time log configuration IAM role</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Kinesis data stream where you are sending real-time log data.
         * </p>
         * 
         * @param streamARN
         *        The Amazon Resource Name (ARN) of the Kinesis data stream where you are sending real-time log data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamARN(String streamARN);
    }

    static final class BuilderImpl implements Builder {
        private String roleARN;

        private String streamARN;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisStreamConfig model) {
            roleARN(model.roleARN);
            streamARN(model.streamARN);
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getStreamARN() {
            return streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        public KinesisStreamConfig build() {
            return new KinesisStreamConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
