/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDistributionsByCachePolicyIdResponse extends CloudFrontResponse implements
        ToCopyableBuilder<ListDistributionsByCachePolicyIdResponse.Builder, ListDistributionsByCachePolicyIdResponse> {
    private static final SdkField<DistributionIdList> DISTRIBUTION_ID_LIST_FIELD = SdkField
            .<DistributionIdList> builder(MarshallingType.SDK_POJO)
            .memberName("DistributionIdList")
            .getter(getter(ListDistributionsByCachePolicyIdResponse::distributionIdList))
            .setter(setter(Builder::distributionIdList))
            .constructor(DistributionIdList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistributionIdList")
                    .unmarshallLocationName("DistributionIdList").build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTRIBUTION_ID_LIST_FIELD));

    private final DistributionIdList distributionIdList;

    private ListDistributionsByCachePolicyIdResponse(BuilderImpl builder) {
        super(builder);
        this.distributionIdList = builder.distributionIdList;
    }

    /**
     * <p>
     * A list of distribution IDs.
     * </p>
     * 
     * @return A list of distribution IDs.
     */
    public DistributionIdList distributionIdList() {
        return distributionIdList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(distributionIdList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDistributionsByCachePolicyIdResponse)) {
            return false;
        }
        ListDistributionsByCachePolicyIdResponse other = (ListDistributionsByCachePolicyIdResponse) obj;
        return Objects.equals(distributionIdList(), other.distributionIdList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListDistributionsByCachePolicyIdResponse").add("DistributionIdList", distributionIdList())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DistributionIdList":
            return Optional.ofNullable(clazz.cast(distributionIdList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDistributionsByCachePolicyIdResponse, T> g) {
        return obj -> g.apply((ListDistributionsByCachePolicyIdResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDistributionsByCachePolicyIdResponse> {
        /**
         * <p>
         * A list of distribution IDs.
         * </p>
         * 
         * @param distributionIdList
         *        A list of distribution IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionIdList(DistributionIdList distributionIdList);

        /**
         * <p>
         * A list of distribution IDs.
         * </p>
         * This is a convenience that creates an instance of the {@link DistributionIdList.Builder} avoiding the need to
         * create one manually via {@link DistributionIdList#builder()}.
         *
         * When the {@link Consumer} completes, {@link DistributionIdList.Builder#build()} is called immediately and its
         * result is passed to {@link #distributionIdList(DistributionIdList)}.
         * 
         * @param distributionIdList
         *        a consumer that will call methods on {@link DistributionIdList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #distributionIdList(DistributionIdList)
         */
        default Builder distributionIdList(Consumer<DistributionIdList.Builder> distributionIdList) {
            return distributionIdList(DistributionIdList.builder().applyMutation(distributionIdList).build());
        }
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private DistributionIdList distributionIdList;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDistributionsByCachePolicyIdResponse model) {
            super(model);
            distributionIdList(model.distributionIdList);
        }

        public final DistributionIdList.Builder getDistributionIdList() {
            return distributionIdList != null ? distributionIdList.toBuilder() : null;
        }

        @Override
        public final Builder distributionIdList(DistributionIdList distributionIdList) {
            this.distributionIdList = distributionIdList;
            return this;
        }

        public final void setDistributionIdList(DistributionIdList.BuilderImpl distributionIdList) {
            this.distributionIdList = distributionIdList != null ? distributionIdList.build() : null;
        }

        @Override
        public ListDistributionsByCachePolicyIdResponse build() {
            return new ListDistributionsByCachePolicyIdResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
