/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request to list invalidations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInvalidationsRequest extends CloudFrontRequest implements
        ToCopyableBuilder<ListInvalidationsRequest.Builder, ListInvalidationsRequest> {
    private static final SdkField<String> DISTRIBUTION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DistributionId")
            .getter(getter(ListInvalidationsRequest::distributionId))
            .setter(setter(Builder::distributionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DistributionId")
                    .unmarshallLocationName("DistributionId").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Marker")
            .getter(getter(ListInvalidationsRequest::marker))
            .setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Marker")
                    .unmarshallLocationName("Marker").build()).build();

    private static final SdkField<String> MAX_ITEMS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MaxItems")
            .getter(getter(ListInvalidationsRequest::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxItems")
                    .unmarshallLocationName("MaxItems").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTRIBUTION_ID_FIELD,
            MARKER_FIELD, MAX_ITEMS_FIELD));

    private final String distributionId;

    private final String marker;

    private final String maxItems;

    private ListInvalidationsRequest(BuilderImpl builder) {
        super(builder);
        this.distributionId = builder.distributionId;
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * The distribution's ID.
     * </p>
     * 
     * @return The distribution's ID.
     */
    public String distributionId() {
        return distributionId;
    }

    /**
     * <p>
     * Use this parameter when paginating results to indicate where to begin in your list of invalidation batches.
     * Because the results are returned in decreasing order from most recent to oldest, the most recent results are on
     * the first page, the second page will contain earlier results, and so on. To get the next page of results, set
     * <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response. This value is
     * the same as the ID of the last invalidation batch on that page.
     * </p>
     * 
     * @return Use this parameter when paginating results to indicate where to begin in your list of invalidation
     *         batches. Because the results are returned in decreasing order from most recent to oldest, the most recent
     *         results are on the first page, the second page will contain earlier results, and so on. To get the next
     *         page of results, set <code>Marker</code> to the value of the <code>NextMarker</code> from the current
     *         page's response. This value is the same as the ID of the last invalidation batch on that page.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * The maximum number of invalidation batches that you want in the response body.
     * </p>
     * 
     * @return The maximum number of invalidation batches that you want in the response body.
     */
    public String maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(distributionId());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInvalidationsRequest)) {
            return false;
        }
        ListInvalidationsRequest other = (ListInvalidationsRequest) obj;
        return Objects.equals(distributionId(), other.distributionId()) && Objects.equals(marker(), other.marker())
                && Objects.equals(maxItems(), other.maxItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListInvalidationsRequest").add("DistributionId", distributionId()).add("Marker", marker())
                .add("MaxItems", maxItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DistributionId":
            return Optional.ofNullable(clazz.cast(distributionId()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInvalidationsRequest, T> g) {
        return obj -> g.apply((ListInvalidationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListInvalidationsRequest> {
        /**
         * <p>
         * The distribution's ID.
         * </p>
         * 
         * @param distributionId
         *        The distribution's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionId(String distributionId);

        /**
         * <p>
         * Use this parameter when paginating results to indicate where to begin in your list of invalidation batches.
         * Because the results are returned in decreasing order from most recent to oldest, the most recent results are
         * on the first page, the second page will contain earlier results, and so on. To get the next page of results,
         * set <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response. This
         * value is the same as the ID of the last invalidation batch on that page.
         * </p>
         * 
         * @param marker
         *        Use this parameter when paginating results to indicate where to begin in your list of invalidation
         *        batches. Because the results are returned in decreasing order from most recent to oldest, the most
         *        recent results are on the first page, the second page will contain earlier results, and so on. To get
         *        the next page of results, set <code>Marker</code> to the value of the <code>NextMarker</code> from the
         *        current page's response. This value is the same as the ID of the last invalidation batch on that page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The maximum number of invalidation batches that you want in the response body.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of invalidation batches that you want in the response body.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private String distributionId;

        private String marker;

        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInvalidationsRequest model) {
            super(model);
            distributionId(model.distributionId);
            marker(model.marker);
            maxItems(model.maxItems);
        }

        public final String getDistributionId() {
            return distributionId;
        }

        @Override
        public final Builder distributionId(String distributionId) {
            this.distributionId = distributionId;
            return this;
        }

        public final void setDistributionId(String distributionId) {
            this.distributionId = distributionId;
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListInvalidationsRequest build() {
            return new ListInvalidationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
