/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRealtimeLogConfigsResponse extends CloudFrontResponse implements
        ToCopyableBuilder<ListRealtimeLogConfigsResponse.Builder, ListRealtimeLogConfigsResponse> {
    private static final SdkField<RealtimeLogConfigs> REALTIME_LOG_CONFIGS_FIELD = SdkField
            .<RealtimeLogConfigs> builder(MarshallingType.SDK_POJO)
            .memberName("RealtimeLogConfigs")
            .getter(getter(ListRealtimeLogConfigsResponse::realtimeLogConfigs))
            .setter(setter(Builder::realtimeLogConfigs))
            .constructor(RealtimeLogConfigs::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RealtimeLogConfigs")
                    .unmarshallLocationName("RealtimeLogConfigs").build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REALTIME_LOG_CONFIGS_FIELD));

    private final RealtimeLogConfigs realtimeLogConfigs;

    private ListRealtimeLogConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.realtimeLogConfigs = builder.realtimeLogConfigs;
    }

    /**
     * <p>
     * A list of real-time log configurations.
     * </p>
     * 
     * @return A list of real-time log configurations.
     */
    public RealtimeLogConfigs realtimeLogConfigs() {
        return realtimeLogConfigs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(realtimeLogConfigs());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRealtimeLogConfigsResponse)) {
            return false;
        }
        ListRealtimeLogConfigsResponse other = (ListRealtimeLogConfigsResponse) obj;
        return Objects.equals(realtimeLogConfigs(), other.realtimeLogConfigs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListRealtimeLogConfigsResponse").add("RealtimeLogConfigs", realtimeLogConfigs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RealtimeLogConfigs":
            return Optional.ofNullable(clazz.cast(realtimeLogConfigs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRealtimeLogConfigsResponse, T> g) {
        return obj -> g.apply((ListRealtimeLogConfigsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListRealtimeLogConfigsResponse> {
        /**
         * <p>
         * A list of real-time log configurations.
         * </p>
         * 
         * @param realtimeLogConfigs
         *        A list of real-time log configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder realtimeLogConfigs(RealtimeLogConfigs realtimeLogConfigs);

        /**
         * <p>
         * A list of real-time log configurations.
         * </p>
         * This is a convenience that creates an instance of the {@link RealtimeLogConfigs.Builder} avoiding the need to
         * create one manually via {@link RealtimeLogConfigs#builder()}.
         *
         * When the {@link Consumer} completes, {@link RealtimeLogConfigs.Builder#build()} is called immediately and its
         * result is passed to {@link #realtimeLogConfigs(RealtimeLogConfigs)}.
         * 
         * @param realtimeLogConfigs
         *        a consumer that will call methods on {@link RealtimeLogConfigs.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #realtimeLogConfigs(RealtimeLogConfigs)
         */
        default Builder realtimeLogConfigs(Consumer<RealtimeLogConfigs.Builder> realtimeLogConfigs) {
            return realtimeLogConfigs(RealtimeLogConfigs.builder().applyMutation(realtimeLogConfigs).build());
        }
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private RealtimeLogConfigs realtimeLogConfigs;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRealtimeLogConfigsResponse model) {
            super(model);
            realtimeLogConfigs(model.realtimeLogConfigs);
        }

        public final RealtimeLogConfigs.Builder getRealtimeLogConfigs() {
            return realtimeLogConfigs != null ? realtimeLogConfigs.toBuilder() : null;
        }

        @Override
        public final Builder realtimeLogConfigs(RealtimeLogConfigs realtimeLogConfigs) {
            this.realtimeLogConfigs = realtimeLogConfigs;
            return this;
        }

        public final void setRealtimeLogConfigs(RealtimeLogConfigs.BuilderImpl realtimeLogConfigs) {
            this.realtimeLogConfigs = realtimeLogConfigs != null ? realtimeLogConfigs.build() : null;
        }

        @Override
        public ListRealtimeLogConfigsResponse build() {
            return new ListRealtimeLogConfigsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
