/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The returned result of the corresponding request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStreamingDistributionsResponse extends CloudFrontResponse implements
        ToCopyableBuilder<ListStreamingDistributionsResponse.Builder, ListStreamingDistributionsResponse> {
    private static final SdkField<StreamingDistributionList> STREAMING_DISTRIBUTION_LIST_FIELD = SdkField
            .<StreamingDistributionList> builder(MarshallingType.SDK_POJO)
            .memberName("StreamingDistributionList")
            .getter(getter(ListStreamingDistributionsResponse::streamingDistributionList))
            .setter(setter(Builder::streamingDistributionList))
            .constructor(StreamingDistributionList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamingDistributionList")
                    .unmarshallLocationName("StreamingDistributionList").build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(STREAMING_DISTRIBUTION_LIST_FIELD));

    private final StreamingDistributionList streamingDistributionList;

    private ListStreamingDistributionsResponse(BuilderImpl builder) {
        super(builder);
        this.streamingDistributionList = builder.streamingDistributionList;
    }

    /**
     * <p>
     * The <code>StreamingDistributionList</code> type.
     * </p>
     * 
     * @return The <code>StreamingDistributionList</code> type.
     */
    public StreamingDistributionList streamingDistributionList() {
        return streamingDistributionList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamingDistributionList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamingDistributionsResponse)) {
            return false;
        }
        ListStreamingDistributionsResponse other = (ListStreamingDistributionsResponse) obj;
        return Objects.equals(streamingDistributionList(), other.streamingDistributionList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListStreamingDistributionsResponse")
                .add("StreamingDistributionList", streamingDistributionList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamingDistributionList":
            return Optional.ofNullable(clazz.cast(streamingDistributionList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStreamingDistributionsResponse, T> g) {
        return obj -> g.apply((ListStreamingDistributionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListStreamingDistributionsResponse> {
        /**
         * <p>
         * The <code>StreamingDistributionList</code> type.
         * </p>
         * 
         * @param streamingDistributionList
         *        The <code>StreamingDistributionList</code> type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingDistributionList(StreamingDistributionList streamingDistributionList);

        /**
         * <p>
         * The <code>StreamingDistributionList</code> type.
         * </p>
         * This is a convenience that creates an instance of the {@link StreamingDistributionList.Builder} avoiding the
         * need to create one manually via {@link StreamingDistributionList#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamingDistributionList.Builder#build()} is called immediately
         * and its result is passed to {@link #streamingDistributionList(StreamingDistributionList)}.
         * 
         * @param streamingDistributionList
         *        a consumer that will call methods on {@link StreamingDistributionList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamingDistributionList(StreamingDistributionList)
         */
        default Builder streamingDistributionList(Consumer<StreamingDistributionList.Builder> streamingDistributionList) {
            return streamingDistributionList(StreamingDistributionList.builder().applyMutation(streamingDistributionList).build());
        }
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private StreamingDistributionList streamingDistributionList;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamingDistributionsResponse model) {
            super(model);
            streamingDistributionList(model.streamingDistributionList);
        }

        public final StreamingDistributionList.Builder getStreamingDistributionList() {
            return streamingDistributionList != null ? streamingDistributionList.toBuilder() : null;
        }

        @Override
        public final Builder streamingDistributionList(StreamingDistributionList streamingDistributionList) {
            this.streamingDistributionList = streamingDistributionList;
            return this;
        }

        public final void setStreamingDistributionList(StreamingDistributionList.BuilderImpl streamingDistributionList) {
            this.streamingDistributionList = streamingDistributionList != null ? streamingDistributionList.build() : null;
        }

        @Override
        public ListStreamingDistributionsResponse build() {
            return new ListStreamingDistributionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
