/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains <code>HeaderName</code> and <code>HeaderValue</code> elements, if any, for this
 * distribution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OriginCustomHeader implements SdkPojo, Serializable,
        ToCopyableBuilder<OriginCustomHeader.Builder, OriginCustomHeader> {
    private static final SdkField<String> HEADER_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HeaderName")
            .getter(getter(OriginCustomHeader::headerName))
            .setter(setter(Builder::headerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeaderName")
                    .unmarshallLocationName("HeaderName").build()).build();

    private static final SdkField<String> HEADER_VALUE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HeaderValue")
            .getter(getter(OriginCustomHeader::headerValue))
            .setter(setter(Builder::headerValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeaderValue")
                    .unmarshallLocationName("HeaderValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEADER_NAME_FIELD,
            HEADER_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String headerName;

    private final String headerValue;

    private OriginCustomHeader(BuilderImpl builder) {
        this.headerName = builder.headerName;
        this.headerValue = builder.headerValue;
    }

    /**
     * <p>
     * The name of a header that you want CloudFront to send to your origin. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/forward-custom-headers.html">Adding
     * Custom Headers to Origin Requests</a> in the <i> Amazon CloudFront Developer Guide</i>.
     * </p>
     * 
     * @return The name of a header that you want CloudFront to send to your origin. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/forward-custom-headers.html"
     *         >Adding Custom Headers to Origin Requests</a> in the <i> Amazon CloudFront Developer Guide</i>.
     */
    public String headerName() {
        return headerName;
    }

    /**
     * <p>
     * The value for the header that you specified in the <code>HeaderName</code> field.
     * </p>
     * 
     * @return The value for the header that you specified in the <code>HeaderName</code> field.
     */
    public String headerValue() {
        return headerValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(headerName());
        hashCode = 31 * hashCode + Objects.hashCode(headerValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OriginCustomHeader)) {
            return false;
        }
        OriginCustomHeader other = (OriginCustomHeader) obj;
        return Objects.equals(headerName(), other.headerName()) && Objects.equals(headerValue(), other.headerValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("OriginCustomHeader").add("HeaderName", headerName()).add("HeaderValue", headerValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HeaderName":
            return Optional.ofNullable(clazz.cast(headerName()));
        case "HeaderValue":
            return Optional.ofNullable(clazz.cast(headerValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OriginCustomHeader, T> g) {
        return obj -> g.apply((OriginCustomHeader) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OriginCustomHeader> {
        /**
         * <p>
         * The name of a header that you want CloudFront to send to your origin. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/forward-custom-headers.html">Adding
         * Custom Headers to Origin Requests</a> in the <i> Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param headerName
         *        The name of a header that you want CloudFront to send to your origin. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/forward-custom-headers.html">
         *        Adding Custom Headers to Origin Requests</a> in the <i> Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headerName(String headerName);

        /**
         * <p>
         * The value for the header that you specified in the <code>HeaderName</code> field.
         * </p>
         * 
         * @param headerValue
         *        The value for the header that you specified in the <code>HeaderName</code> field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headerValue(String headerValue);
    }

    static final class BuilderImpl implements Builder {
        private String headerName;

        private String headerValue;

        private BuilderImpl() {
        }

        private BuilderImpl(OriginCustomHeader model) {
            headerName(model.headerName);
            headerValue(model.headerValue);
        }

        public final String getHeaderName() {
            return headerName;
        }

        @Override
        public final Builder headerName(String headerName) {
            this.headerName = headerName;
            return this;
        }

        public final void setHeaderName(String headerName) {
            this.headerName = headerName;
        }

        public final String getHeaderValue() {
            return headerValue;
        }

        @Override
        public final Builder headerValue(String headerValue) {
            this.headerValue = headerValue;
            return this;
        }

        public final void setHeaderValue(String headerValue) {
            this.headerValue = headerValue;
        }

        @Override
        public OriginCustomHeader build() {
            return new OriginCustomHeader(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
