/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An origin in an origin group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OriginGroupMember implements SdkPojo, Serializable,
        ToCopyableBuilder<OriginGroupMember.Builder, OriginGroupMember> {
    private static final SdkField<String> ORIGIN_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OriginId")
            .getter(getter(OriginGroupMember::originId))
            .setter(setter(Builder::originId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginId")
                    .unmarshallLocationName("OriginId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORIGIN_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String originId;

    private OriginGroupMember(BuilderImpl builder) {
        this.originId = builder.originId;
    }

    /**
     * <p>
     * The ID for an origin in an origin group.
     * </p>
     * 
     * @return The ID for an origin in an origin group.
     */
    public String originId() {
        return originId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(originId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OriginGroupMember)) {
            return false;
        }
        OriginGroupMember other = (OriginGroupMember) obj;
        return Objects.equals(originId(), other.originId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("OriginGroupMember").add("OriginId", originId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OriginId":
            return Optional.ofNullable(clazz.cast(originId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OriginGroupMember, T> g) {
        return obj -> g.apply((OriginGroupMember) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OriginGroupMember> {
        /**
         * <p>
         * The ID for an origin in an origin group.
         * </p>
         * 
         * @param originId
         *        The ID for an origin in an origin group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originId(String originId);
    }

    static final class BuilderImpl implements Builder {
        private String originId;

        private BuilderImpl() {
        }

        private BuilderImpl(OriginGroupMember model) {
            originId(model.originId);
        }

        public final String getOriginId() {
            return originId;
        }

        @Override
        public final Builder originId(String originId) {
            this.originId = originId;
            return this;
        }

        public final void setOriginId(String originId) {
            this.originId = originId;
        }

        @Override
        public OriginGroupMember build() {
            return new OriginGroupMember(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
