/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateOriginRequestPolicyRequest extends CloudFrontRequest implements
        ToCopyableBuilder<UpdateOriginRequestPolicyRequest.Builder, UpdateOriginRequestPolicyRequest> {
    private static final SdkField<OriginRequestPolicyConfig> ORIGIN_REQUEST_POLICY_CONFIG_FIELD = SdkField
            .<OriginRequestPolicyConfig> builder(MarshallingType.SDK_POJO)
            .memberName("OriginRequestPolicyConfig")
            .getter(getter(UpdateOriginRequestPolicyRequest::originRequestPolicyConfig))
            .setter(setter(Builder::originRequestPolicyConfig))
            .constructor(OriginRequestPolicyConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginRequestPolicyConfig")
                    .unmarshallLocationName("OriginRequestPolicyConfig").build(), PayloadTrait.create()).build();

    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(UpdateOriginRequestPolicyRequest::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<String> IF_MATCH_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IfMatch")
            .getter(getter(UpdateOriginRequestPolicyRequest::ifMatch))
            .setter(setter(Builder::ifMatch))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-Match")
                    .unmarshallLocationName("If-Match").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ORIGIN_REQUEST_POLICY_CONFIG_FIELD, ID_FIELD, IF_MATCH_FIELD));

    private final OriginRequestPolicyConfig originRequestPolicyConfig;

    private final String id;

    private final String ifMatch;

    private UpdateOriginRequestPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.originRequestPolicyConfig = builder.originRequestPolicyConfig;
        this.id = builder.id;
        this.ifMatch = builder.ifMatch;
    }

    /**
     * <p>
     * An origin request policy configuration.
     * </p>
     * 
     * @return An origin request policy configuration.
     */
    public OriginRequestPolicyConfig originRequestPolicyConfig() {
        return originRequestPolicyConfig;
    }

    /**
     * <p>
     * The unique identifier for the origin request policy that you are updating. The identifier is returned in a cache
     * behavior’s <code>OriginRequestPolicyId</code> field in the response to <code>GetDistributionConfig</code>.
     * </p>
     * 
     * @return The unique identifier for the origin request policy that you are updating. The identifier is returned in
     *         a cache behavior’s <code>OriginRequestPolicyId</code> field in the response to
     *         <code>GetDistributionConfig</code>.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The version of the origin request policy that you are updating. The version is returned in the origin request
     * policy’s <code>ETag</code> field in the response to <code>GetOriginRequestPolicyConfig</code>.
     * </p>
     * 
     * @return The version of the origin request policy that you are updating. The version is returned in the origin
     *         request policy’s <code>ETag</code> field in the response to <code>GetOriginRequestPolicyConfig</code>.
     */
    public String ifMatch() {
        return ifMatch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(originRequestPolicyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(ifMatch());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateOriginRequestPolicyRequest)) {
            return false;
        }
        UpdateOriginRequestPolicyRequest other = (UpdateOriginRequestPolicyRequest) obj;
        return Objects.equals(originRequestPolicyConfig(), other.originRequestPolicyConfig()) && Objects.equals(id(), other.id())
                && Objects.equals(ifMatch(), other.ifMatch());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateOriginRequestPolicyRequest").add("OriginRequestPolicyConfig", originRequestPolicyConfig())
                .add("Id", id()).add("IfMatch", ifMatch()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OriginRequestPolicyConfig":
            return Optional.ofNullable(clazz.cast(originRequestPolicyConfig()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "IfMatch":
            return Optional.ofNullable(clazz.cast(ifMatch()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateOriginRequestPolicyRequest, T> g) {
        return obj -> g.apply((UpdateOriginRequestPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateOriginRequestPolicyRequest> {
        /**
         * <p>
         * An origin request policy configuration.
         * </p>
         * 
         * @param originRequestPolicyConfig
         *        An origin request policy configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originRequestPolicyConfig(OriginRequestPolicyConfig originRequestPolicyConfig);

        /**
         * <p>
         * An origin request policy configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link OriginRequestPolicyConfig.Builder} avoiding the
         * need to create one manually via {@link OriginRequestPolicyConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link OriginRequestPolicyConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #originRequestPolicyConfig(OriginRequestPolicyConfig)}.
         * 
         * @param originRequestPolicyConfig
         *        a consumer that will call methods on {@link OriginRequestPolicyConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #originRequestPolicyConfig(OriginRequestPolicyConfig)
         */
        default Builder originRequestPolicyConfig(Consumer<OriginRequestPolicyConfig.Builder> originRequestPolicyConfig) {
            return originRequestPolicyConfig(OriginRequestPolicyConfig.builder().applyMutation(originRequestPolicyConfig).build());
        }

        /**
         * <p>
         * The unique identifier for the origin request policy that you are updating. The identifier is returned in a
         * cache behavior’s <code>OriginRequestPolicyId</code> field in the response to
         * <code>GetDistributionConfig</code>.
         * </p>
         * 
         * @param id
         *        The unique identifier for the origin request policy that you are updating. The identifier is returned
         *        in a cache behavior’s <code>OriginRequestPolicyId</code> field in the response to
         *        <code>GetDistributionConfig</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The version of the origin request policy that you are updating. The version is returned in the origin request
         * policy’s <code>ETag</code> field in the response to <code>GetOriginRequestPolicyConfig</code>.
         * </p>
         * 
         * @param ifMatch
         *        The version of the origin request policy that you are updating. The version is returned in the origin
         *        request policy’s <code>ETag</code> field in the response to <code>GetOriginRequestPolicyConfig</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ifMatch(String ifMatch);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private OriginRequestPolicyConfig originRequestPolicyConfig;

        private String id;

        private String ifMatch;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateOriginRequestPolicyRequest model) {
            super(model);
            originRequestPolicyConfig(model.originRequestPolicyConfig);
            id(model.id);
            ifMatch(model.ifMatch);
        }

        public final OriginRequestPolicyConfig.Builder getOriginRequestPolicyConfig() {
            return originRequestPolicyConfig != null ? originRequestPolicyConfig.toBuilder() : null;
        }

        @Override
        public final Builder originRequestPolicyConfig(OriginRequestPolicyConfig originRequestPolicyConfig) {
            this.originRequestPolicyConfig = originRequestPolicyConfig;
            return this;
        }

        public final void setOriginRequestPolicyConfig(OriginRequestPolicyConfig.BuilderImpl originRequestPolicyConfig) {
            this.originRequestPolicyConfig = originRequestPolicyConfig != null ? originRequestPolicyConfig.build() : null;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getIfMatch() {
            return ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateOriginRequestPolicyRequest build() {
            return new UpdateOriginRequestPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
