/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRealtimeLogConfigRequest extends CloudFrontRequest implements
        ToCopyableBuilder<UpdateRealtimeLogConfigRequest.Builder, UpdateRealtimeLogConfigRequest> {
    private static final SdkField<List<EndPoint>> END_POINTS_FIELD = SdkField
            .<List<EndPoint>> builder(MarshallingType.LIST)
            .memberName("EndPoints")
            .getter(getter(UpdateRealtimeLogConfigRequest::endPoints))
            .setter(setter(Builder::endPoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndPoints")
                    .unmarshallLocationName("EndPoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EndPoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(EndPoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> FIELDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Fields")
            .getter(getter(UpdateRealtimeLogConfigRequest::fields))
            .setter(setter(Builder::fields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fields")
                    .unmarshallLocationName("Fields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Field")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Field").unmarshallLocationName("Field").build()).build())
                            .build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(UpdateRealtimeLogConfigRequest::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ARN")
            .getter(getter(UpdateRealtimeLogConfigRequest::arn))
            .setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").unmarshallLocationName("ARN")
                    .build()).build();

    private static final SdkField<Long> SAMPLING_RATE_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("SamplingRate")
            .getter(getter(UpdateRealtimeLogConfigRequest::samplingRate))
            .setter(setter(Builder::samplingRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SamplingRate")
                    .unmarshallLocationName("SamplingRate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_POINTS_FIELD,
            FIELDS_FIELD, NAME_FIELD, ARN_FIELD, SAMPLING_RATE_FIELD));

    private final List<EndPoint> endPoints;

    private final List<String> fields;

    private final String name;

    private final String arn;

    private final Long samplingRate;

    private UpdateRealtimeLogConfigRequest(BuilderImpl builder) {
        super(builder);
        this.endPoints = builder.endPoints;
        this.fields = builder.fields;
        this.name = builder.name;
        this.arn = builder.arn;
        this.samplingRate = builder.samplingRate;
    }

    /**
     * Returns true if the EndPoints property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEndPoints() {
        return endPoints != null && !(endPoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains information about the Amazon Kinesis data stream where you are sending real-time log data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEndPoints()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Contains information about the Amazon Kinesis data stream where you are sending real-time log data.
     */
    public List<EndPoint> endPoints() {
        return endPoints;
    }

    /**
     * Returns true if the Fields property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFields() {
        return fields != null && !(fields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of fields to include in each real-time log record.
     * </p>
     * <p>
     * For more information about fields, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields"
     * >Real-time log configuration fields</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFields()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of fields to include in each real-time log record.</p>
     *         <p>
     *         For more information about fields, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields"
     *         >Real-time log configuration fields</a> in the <i>Amazon CloudFront Developer Guide</i>.
     */
    public List<String> fields() {
        return fields;
    }

    /**
     * <p>
     * The name for this real-time log configuration.
     * </p>
     * 
     * @return The name for this real-time log configuration.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for this real-time log configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for this real-time log configuration.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The sampling rate for this real-time log configuration. The sampling rate determines the percentage of viewer
     * requests that are represented in the real-time log data. You must provide an integer between 1 and 100,
     * inclusive.
     * </p>
     * 
     * @return The sampling rate for this real-time log configuration. The sampling rate determines the percentage of
     *         viewer requests that are represented in the real-time log data. You must provide an integer between 1 and
     *         100, inclusive.
     */
    public Long samplingRate() {
        return samplingRate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endPoints());
        hashCode = 31 * hashCode + Objects.hashCode(fields());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(samplingRate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRealtimeLogConfigRequest)) {
            return false;
        }
        UpdateRealtimeLogConfigRequest other = (UpdateRealtimeLogConfigRequest) obj;
        return Objects.equals(endPoints(), other.endPoints()) && Objects.equals(fields(), other.fields())
                && Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(samplingRate(), other.samplingRate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateRealtimeLogConfigRequest").add("EndPoints", endPoints()).add("Fields", fields())
                .add("Name", name()).add("ARN", arn()).add("SamplingRate", samplingRate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndPoints":
            return Optional.ofNullable(clazz.cast(endPoints()));
        case "Fields":
            return Optional.ofNullable(clazz.cast(fields()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        case "SamplingRate":
            return Optional.ofNullable(clazz.cast(samplingRate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRealtimeLogConfigRequest, T> g) {
        return obj -> g.apply((UpdateRealtimeLogConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateRealtimeLogConfigRequest> {
        /**
         * <p>
         * Contains information about the Amazon Kinesis data stream where you are sending real-time log data.
         * </p>
         * 
         * @param endPoints
         *        Contains information about the Amazon Kinesis data stream where you are sending real-time log data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endPoints(Collection<EndPoint> endPoints);

        /**
         * <p>
         * Contains information about the Amazon Kinesis data stream where you are sending real-time log data.
         * </p>
         * 
         * @param endPoints
         *        Contains information about the Amazon Kinesis data stream where you are sending real-time log data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endPoints(EndPoint... endPoints);

        /**
         * <p>
         * Contains information about the Amazon Kinesis data stream where you are sending real-time log data.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EndPoint>.Builder} avoiding the need to
         * create one manually via {@link List<EndPoint>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EndPoint>.Builder#build()} is called immediately and its
         * result is passed to {@link #endPoints(List<EndPoint>)}.
         * 
         * @param endPoints
         *        a consumer that will call methods on {@link List<EndPoint>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endPoints(List<EndPoint>)
         */
        Builder endPoints(Consumer<EndPoint.Builder>... endPoints);

        /**
         * <p>
         * A list of fields to include in each real-time log record.
         * </p>
         * <p>
         * For more information about fields, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields"
         * >Real-time log configuration fields</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param fields
         *        A list of fields to include in each real-time log record.</p>
         *        <p>
         *        For more information about fields, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields"
         *        >Real-time log configuration fields</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(Collection<String> fields);

        /**
         * <p>
         * A list of fields to include in each real-time log record.
         * </p>
         * <p>
         * For more information about fields, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields"
         * >Real-time log configuration fields</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param fields
         *        A list of fields to include in each real-time log record.</p>
         *        <p>
         *        For more information about fields, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields"
         *        >Real-time log configuration fields</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(String... fields);

        /**
         * <p>
         * The name for this real-time log configuration.
         * </p>
         * 
         * @param name
         *        The name for this real-time log configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for this real-time log configuration.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) for this real-time log configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The sampling rate for this real-time log configuration. The sampling rate determines the percentage of viewer
         * requests that are represented in the real-time log data. You must provide an integer between 1 and 100,
         * inclusive.
         * </p>
         * 
         * @param samplingRate
         *        The sampling rate for this real-time log configuration. The sampling rate determines the percentage of
         *        viewer requests that are represented in the real-time log data. You must provide an integer between 1
         *        and 100, inclusive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samplingRate(Long samplingRate);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private List<EndPoint> endPoints = DefaultSdkAutoConstructList.getInstance();

        private List<String> fields = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private String arn;

        private Long samplingRate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRealtimeLogConfigRequest model) {
            super(model);
            endPoints(model.endPoints);
            fields(model.fields);
            name(model.name);
            arn(model.arn);
            samplingRate(model.samplingRate);
        }

        public final Collection<EndPoint.Builder> getEndPoints() {
            return endPoints != null ? endPoints.stream().map(EndPoint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder endPoints(Collection<EndPoint> endPoints) {
            this.endPoints = EndPointListCopier.copy(endPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endPoints(EndPoint... endPoints) {
            endPoints(Arrays.asList(endPoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endPoints(Consumer<EndPoint.Builder>... endPoints) {
            endPoints(Stream.of(endPoints).map(c -> EndPoint.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEndPoints(Collection<EndPoint.BuilderImpl> endPoints) {
            this.endPoints = EndPointListCopier.copyFromBuilder(endPoints);
        }

        public final Collection<String> getFields() {
            return fields;
        }

        @Override
        public final Builder fields(Collection<String> fields) {
            this.fields = FieldListCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(String... fields) {
            fields(Arrays.asList(fields));
            return this;
        }

        public final void setFields(Collection<String> fields) {
            this.fields = FieldListCopier.copy(fields);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Long getSamplingRate() {
            return samplingRate;
        }

        @Override
        public final Builder samplingRate(Long samplingRate) {
            this.samplingRate = samplingRate;
            return this;
        }

        public final void setSamplingRate(Long samplingRate) {
            this.samplingRate = samplingRate;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRealtimeLogConfigRequest build() {
            return new UpdateRealtimeLogConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
