/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of the <code>ListHsms</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListHsmsResponse extends CloudHsmResponse implements
        ToCopyableBuilder<ListHsmsResponse.Builder, ListHsmsResponse> {
    private static final SdkField<List<String>> HSM_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("HsmList")
            .getter(getter(ListHsmsResponse::hsmList))
            .setter(setter(Builder::hsmList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListHsmsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HSM_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> hsmList;

    private final String nextToken;

    private ListHsmsResponse(BuilderImpl builder) {
        super(builder);
        this.hsmList = builder.hsmList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the HsmList property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasHsmList() {
        return hsmList != null && !(hsmList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of ARNs that identify the HSMs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasHsmList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of ARNs that identify the HSMs.
     */
    public List<String> hsmList() {
        return hsmList;
    }

    /**
     * <p>
     * If not null, more results are available. Pass this value to <code>ListHsms</code> to retrieve the next set of
     * items.
     * </p>
     * 
     * @return If not null, more results are available. Pass this value to <code>ListHsms</code> to retrieve the next
     *         set of items.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hsmList());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHsmsResponse)) {
            return false;
        }
        ListHsmsResponse other = (ListHsmsResponse) obj;
        return Objects.equals(hsmList(), other.hsmList()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListHsmsResponse").add("HsmList", hsmList()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HsmList":
            return Optional.ofNullable(clazz.cast(hsmList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListHsmsResponse, T> g) {
        return obj -> g.apply((ListHsmsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudHsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListHsmsResponse> {
        /**
         * <p>
         * The list of ARNs that identify the HSMs.
         * </p>
         * 
         * @param hsmList
         *        The list of ARNs that identify the HSMs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsmList(Collection<String> hsmList);

        /**
         * <p>
         * The list of ARNs that identify the HSMs.
         * </p>
         * 
         * @param hsmList
         *        The list of ARNs that identify the HSMs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsmList(String... hsmList);

        /**
         * <p>
         * If not null, more results are available. Pass this value to <code>ListHsms</code> to retrieve the next set of
         * items.
         * </p>
         * 
         * @param nextToken
         *        If not null, more results are available. Pass this value to <code>ListHsms</code> to retrieve the next
         *        set of items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudHsmResponse.BuilderImpl implements Builder {
        private List<String> hsmList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHsmsResponse model) {
            super(model);
            hsmList(model.hsmList);
            nextToken(model.nextToken);
        }

        public final Collection<String> getHsmList() {
            return hsmList;
        }

        @Override
        public final Builder hsmList(Collection<String> hsmList) {
            this.hsmList = HsmListCopier.copy(hsmList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hsmList(String... hsmList) {
            hsmList(Arrays.asList(hsmList));
            return this;
        }

        public final void setHsmList(Collection<String> hsmList) {
            this.hsmList = HsmListCopier.copy(hsmList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListHsmsResponse build() {
            return new ListHsmsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
