/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemoveTagsFromResourceRequest extends CloudHsmRequest implements
        ToCopyableBuilder<RemoveTagsFromResourceRequest.Builder, RemoveTagsFromResourceRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(RemoveTagsFromResourceRequest::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<List<String>> TAG_KEY_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TagKeyList")
            .getter(getter(RemoveTagsFromResourceRequest::tagKeyList))
            .setter(setter(Builder::tagKeyList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagKeyList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            TAG_KEY_LIST_FIELD));

    private final String resourceArn;

    private final List<String> tagKeyList;

    private RemoveTagsFromResourceRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.tagKeyList = builder.tagKeyList;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS CloudHSM resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS CloudHSM resource.
     */
    public String resourceArn() {
        return resourceArn;
    }

    /**
     * Returns true if the TagKeyList property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTagKeyList() {
        return tagKeyList != null && !(tagKeyList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tag key or keys to remove.
     * </p>
     * <p>
     * Specify only the tag key to remove (not the value). To overwrite the value for an existing tag, use
     * <a>AddTagsToResource</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTagKeyList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tag key or keys to remove.</p>
     *         <p>
     *         Specify only the tag key to remove (not the value). To overwrite the value for an existing tag, use
     *         <a>AddTagsToResource</a>.
     */
    public List<String> tagKeyList() {
        return tagKeyList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(tagKeyList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveTagsFromResourceRequest)) {
            return false;
        }
        RemoveTagsFromResourceRequest other = (RemoveTagsFromResourceRequest) obj;
        return Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(tagKeyList(), other.tagKeyList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RemoveTagsFromResourceRequest").add("ResourceArn", resourceArn())
                .add("TagKeyList", tagKeyList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "TagKeyList":
            return Optional.ofNullable(clazz.cast(tagKeyList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemoveTagsFromResourceRequest, T> g) {
        return obj -> g.apply((RemoveTagsFromResourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudHsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, RemoveTagsFromResourceRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS CloudHSM resource.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the AWS CloudHSM resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The tag key or keys to remove.
         * </p>
         * <p>
         * Specify only the tag key to remove (not the value). To overwrite the value for an existing tag, use
         * <a>AddTagsToResource</a>.
         * </p>
         * 
         * @param tagKeyList
         *        The tag key or keys to remove.</p>
         *        <p>
         *        Specify only the tag key to remove (not the value). To overwrite the value for an existing tag, use
         *        <a>AddTagsToResource</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKeyList(Collection<String> tagKeyList);

        /**
         * <p>
         * The tag key or keys to remove.
         * </p>
         * <p>
         * Specify only the tag key to remove (not the value). To overwrite the value for an existing tag, use
         * <a>AddTagsToResource</a>.
         * </p>
         * 
         * @param tagKeyList
         *        The tag key or keys to remove.</p>
         *        <p>
         *        Specify only the tag key to remove (not the value). To overwrite the value for an existing tag, use
         *        <a>AddTagsToResource</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKeyList(String... tagKeyList);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudHsmRequest.BuilderImpl implements Builder {
        private String resourceArn;

        private List<String> tagKeyList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveTagsFromResourceRequest model) {
            super(model);
            resourceArn(model.resourceArn);
            tagKeyList(model.tagKeyList);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final Collection<String> getTagKeyList() {
            return tagKeyList;
        }

        @Override
        public final Builder tagKeyList(Collection<String> tagKeyList) {
            this.tagKeyList = TagKeyListCopier.copy(tagKeyList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagKeyList(String... tagKeyList) {
            tagKeyList(Arrays.asList(tagKeyList));
            return this;
        }

        public final void setTagKeyList(Collection<String> tagKeyList) {
            this.tagKeyList = TagKeyListCopier.copy(tagKeyList);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RemoveTagsFromResourceRequest build() {
            return new RemoveTagsFromResourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
