/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information for an analysis scheme. Each analysis scheme has a unique name and specifies the language
 * of the text to be processed. The following options can be configured for an analysis scheme: <code>Synonyms</code>,
 * <code>Stopwords</code>, <code>StemmingDictionary</code>, <code>JapaneseTokenizationDictionary</code> and
 * <code>AlgorithmicStemming</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalysisScheme implements SdkPojo, Serializable, ToCopyableBuilder<AnalysisScheme.Builder, AnalysisScheme> {
    private static final SdkField<String> ANALYSIS_SCHEME_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnalysisSchemeName").getter(getter(AnalysisScheme::analysisSchemeName))
            .setter(setter(Builder::analysisSchemeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisSchemeName").build())
            .build();

    private static final SdkField<String> ANALYSIS_SCHEME_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnalysisSchemeLanguage").getter(getter(AnalysisScheme::analysisSchemeLanguageAsString))
            .setter(setter(Builder::analysisSchemeLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisSchemeLanguage").build())
            .build();

    private static final SdkField<AnalysisOptions> ANALYSIS_OPTIONS_FIELD = SdkField
            .<AnalysisOptions> builder(MarshallingType.SDK_POJO).memberName("AnalysisOptions")
            .getter(getter(AnalysisScheme::analysisOptions)).setter(setter(Builder::analysisOptions))
            .constructor(AnalysisOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_SCHEME_NAME_FIELD,
            ANALYSIS_SCHEME_LANGUAGE_FIELD, ANALYSIS_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String analysisSchemeName;

    private final String analysisSchemeLanguage;

    private final AnalysisOptions analysisOptions;

    private AnalysisScheme(BuilderImpl builder) {
        this.analysisSchemeName = builder.analysisSchemeName;
        this.analysisSchemeLanguage = builder.analysisSchemeLanguage;
        this.analysisOptions = builder.analysisOptions;
    }

    /**
     * Returns the value of the AnalysisSchemeName property for this object.
     * 
     * @return The value of the AnalysisSchemeName property for this object.
     */
    public String analysisSchemeName() {
        return analysisSchemeName;
    }

    /**
     * Returns the value of the AnalysisSchemeLanguage property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #analysisSchemeLanguage} will return {@link AnalysisSchemeLanguage#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #analysisSchemeLanguageAsString}.
     * </p>
     * 
     * @return The value of the AnalysisSchemeLanguage property for this object.
     * @see AnalysisSchemeLanguage
     */
    public AnalysisSchemeLanguage analysisSchemeLanguage() {
        return AnalysisSchemeLanguage.fromValue(analysisSchemeLanguage);
    }

    /**
     * Returns the value of the AnalysisSchemeLanguage property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #analysisSchemeLanguage} will return {@link AnalysisSchemeLanguage#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #analysisSchemeLanguageAsString}.
     * </p>
     * 
     * @return The value of the AnalysisSchemeLanguage property for this object.
     * @see AnalysisSchemeLanguage
     */
    public String analysisSchemeLanguageAsString() {
        return analysisSchemeLanguage;
    }

    /**
     * Returns the value of the AnalysisOptions property for this object.
     * 
     * @return The value of the AnalysisOptions property for this object.
     */
    public AnalysisOptions analysisOptions() {
        return analysisOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(analysisSchemeName());
        hashCode = 31 * hashCode + Objects.hashCode(analysisSchemeLanguageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(analysisOptions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisScheme)) {
            return false;
        }
        AnalysisScheme other = (AnalysisScheme) obj;
        return Objects.equals(analysisSchemeName(), other.analysisSchemeName())
                && Objects.equals(analysisSchemeLanguageAsString(), other.analysisSchemeLanguageAsString())
                && Objects.equals(analysisOptions(), other.analysisOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AnalysisScheme").add("AnalysisSchemeName", analysisSchemeName())
                .add("AnalysisSchemeLanguage", analysisSchemeLanguageAsString()).add("AnalysisOptions", analysisOptions())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnalysisSchemeName":
            return Optional.ofNullable(clazz.cast(analysisSchemeName()));
        case "AnalysisSchemeLanguage":
            return Optional.ofNullable(clazz.cast(analysisSchemeLanguageAsString()));
        case "AnalysisOptions":
            return Optional.ofNullable(clazz.cast(analysisOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalysisScheme, T> g) {
        return obj -> g.apply((AnalysisScheme) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalysisScheme> {
        /**
         * Sets the value of the AnalysisSchemeName property for this object.
         *
         * @param analysisSchemeName
         *        The new value for the AnalysisSchemeName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisSchemeName(String analysisSchemeName);

        /**
         * Sets the value of the AnalysisSchemeLanguage property for this object.
         *
         * @param analysisSchemeLanguage
         *        The new value for the AnalysisSchemeLanguage property for this object.
         * @see AnalysisSchemeLanguage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisSchemeLanguage
         */
        Builder analysisSchemeLanguage(String analysisSchemeLanguage);

        /**
         * Sets the value of the AnalysisSchemeLanguage property for this object.
         *
         * @param analysisSchemeLanguage
         *        The new value for the AnalysisSchemeLanguage property for this object.
         * @see AnalysisSchemeLanguage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisSchemeLanguage
         */
        Builder analysisSchemeLanguage(AnalysisSchemeLanguage analysisSchemeLanguage);

        /**
         * Sets the value of the AnalysisOptions property for this object.
         *
         * @param analysisOptions
         *        The new value for the AnalysisOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisOptions(AnalysisOptions analysisOptions);

        /**
         * Sets the value of the AnalysisOptions property for this object.
         *
         * This is a convenience that creates an instance of the {@link AnalysisOptions.Builder} avoiding the need to
         * create one manually via {@link AnalysisOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #analysisOptions(AnalysisOptions)}.
         * 
         * @param analysisOptions
         *        a consumer that will call methods on {@link AnalysisOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #analysisOptions(AnalysisOptions)
         */
        default Builder analysisOptions(Consumer<AnalysisOptions.Builder> analysisOptions) {
            return analysisOptions(AnalysisOptions.builder().applyMutation(analysisOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String analysisSchemeName;

        private String analysisSchemeLanguage;

        private AnalysisOptions analysisOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisScheme model) {
            analysisSchemeName(model.analysisSchemeName);
            analysisSchemeLanguage(model.analysisSchemeLanguage);
            analysisOptions(model.analysisOptions);
        }

        public final String getAnalysisSchemeName() {
            return analysisSchemeName;
        }

        @Override
        public final Builder analysisSchemeName(String analysisSchemeName) {
            this.analysisSchemeName = analysisSchemeName;
            return this;
        }

        public final void setAnalysisSchemeName(String analysisSchemeName) {
            this.analysisSchemeName = analysisSchemeName;
        }

        public final String getAnalysisSchemeLanguage() {
            return analysisSchemeLanguage;
        }

        @Override
        public final Builder analysisSchemeLanguage(String analysisSchemeLanguage) {
            this.analysisSchemeLanguage = analysisSchemeLanguage;
            return this;
        }

        @Override
        public final Builder analysisSchemeLanguage(AnalysisSchemeLanguage analysisSchemeLanguage) {
            this.analysisSchemeLanguage(analysisSchemeLanguage == null ? null : analysisSchemeLanguage.toString());
            return this;
        }

        public final void setAnalysisSchemeLanguage(String analysisSchemeLanguage) {
            this.analysisSchemeLanguage = analysisSchemeLanguage;
        }

        public final AnalysisOptions.Builder getAnalysisOptions() {
            return analysisOptions != null ? analysisOptions.toBuilder() : null;
        }

        @Override
        public final Builder analysisOptions(AnalysisOptions analysisOptions) {
            this.analysisOptions = analysisOptions;
            return this;
        }

        public final void setAnalysisOptions(AnalysisOptions.BuilderImpl analysisOptions) {
            this.analysisOptions = analysisOptions != null ? analysisOptions.build() : null;
        }

        @Override
        public AnalysisScheme build() {
            return new AnalysisScheme(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
