/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for the parameters to the <code><a>DefineSuggester</a></code> operation. Specifies the name of the domain
 * you want to update and the suggester configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DefineSuggesterRequest extends CloudSearchRequest implements
        ToCopyableBuilder<DefineSuggesterRequest.Builder, DefineSuggesterRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(DefineSuggesterRequest::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<Suggester> SUGGESTER_FIELD = SdkField.<Suggester> builder(MarshallingType.SDK_POJO)
            .memberName("Suggester").getter(getter(DefineSuggesterRequest::suggester)).setter(setter(Builder::suggester))
            .constructor(Suggester::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Suggester").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            SUGGESTER_FIELD));

    private final String domainName;

    private final Suggester suggester;

    private DefineSuggesterRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.suggester = builder.suggester;
    }

    /**
     * Returns the value of the DomainName property for this object.
     * 
     * @return The value of the DomainName property for this object.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * Returns the value of the Suggester property for this object.
     * 
     * @return The value of the Suggester property for this object.
     */
    public Suggester suggester() {
        return suggester;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(suggester());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefineSuggesterRequest)) {
            return false;
        }
        DefineSuggesterRequest other = (DefineSuggesterRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(suggester(), other.suggester());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DefineSuggesterRequest").add("DomainName", domainName()).add("Suggester", suggester()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "Suggester":
            return Optional.ofNullable(clazz.cast(suggester()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DefineSuggesterRequest, T> g) {
        return obj -> g.apply((DefineSuggesterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudSearchRequest.Builder, SdkPojo, CopyableBuilder<Builder, DefineSuggesterRequest> {
        /**
         * Sets the value of the DomainName property for this object.
         *
         * @param domainName
         *        The new value for the DomainName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * Sets the value of the Suggester property for this object.
         *
         * @param suggester
         *        The new value for the Suggester property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggester(Suggester suggester);

        /**
         * Sets the value of the Suggester property for this object.
         *
         * This is a convenience that creates an instance of the {@link Suggester.Builder} avoiding the need to create
         * one manually via {@link Suggester#builder()}.
         *
         * When the {@link Consumer} completes, {@link Suggester.Builder#build()} is called immediately and its result
         * is passed to {@link #suggester(Suggester)}.
         * 
         * @param suggester
         *        a consumer that will call methods on {@link Suggester.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #suggester(Suggester)
         */
        default Builder suggester(Consumer<Suggester.Builder> suggester) {
            return suggester(Suggester.builder().applyMutation(suggester).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudSearchRequest.BuilderImpl implements Builder {
        private String domainName;

        private Suggester suggester;

        private BuilderImpl() {
        }

        private BuilderImpl(DefineSuggesterRequest model) {
            super(model);
            domainName(model.domainName);
            suggester(model.suggester);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Suggester.Builder getSuggester() {
            return suggester != null ? suggester.toBuilder() : null;
        }

        @Override
        public final Builder suggester(Suggester suggester) {
            this.suggester = suggester;
            return this;
        }

        public final void setSuggester(Suggester.BuilderImpl suggester) {
            this.suggester = suggester != null ? suggester.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DefineSuggesterRequest build() {
            return new DefineSuggesterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
