/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of an <code>IndexDocuments</code> request. Contains the status of the indexing operation, including the
 * fields being indexed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IndexDocumentsResponse extends CloudSearchResponse implements
        ToCopyableBuilder<IndexDocumentsResponse.Builder, IndexDocumentsResponse> {
    private static final SdkField<List<String>> FIELD_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FieldNames")
            .getter(getter(IndexDocumentsResponse::fieldNames))
            .setter(setter(Builder::fieldNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_NAMES_FIELD));

    private final List<String> fieldNames;

    private IndexDocumentsResponse(BuilderImpl builder) {
        super(builder);
        this.fieldNames = builder.fieldNames;
    }

    /**
     * Returns true if the FieldNames property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFieldNames() {
        return fieldNames != null && !(fieldNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the fields that are currently being indexed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFieldNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The names of the fields that are currently being indexed.
     */
    public List<String> fieldNames() {
        return fieldNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fieldNames());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexDocumentsResponse)) {
            return false;
        }
        IndexDocumentsResponse other = (IndexDocumentsResponse) obj;
        return Objects.equals(fieldNames(), other.fieldNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("IndexDocumentsResponse").add("FieldNames", fieldNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldNames":
            return Optional.ofNullable(clazz.cast(fieldNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IndexDocumentsResponse, T> g) {
        return obj -> g.apply((IndexDocumentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudSearchResponse.Builder, SdkPojo, CopyableBuilder<Builder, IndexDocumentsResponse> {
        /**
         * <p>
         * The names of the fields that are currently being indexed.
         * </p>
         * 
         * @param fieldNames
         *        The names of the fields that are currently being indexed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldNames(Collection<String> fieldNames);

        /**
         * <p>
         * The names of the fields that are currently being indexed.
         * </p>
         * 
         * @param fieldNames
         *        The names of the fields that are currently being indexed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldNames(String... fieldNames);
    }

    static final class BuilderImpl extends CloudSearchResponse.BuilderImpl implements Builder {
        private List<String> fieldNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IndexDocumentsResponse model) {
            super(model);
            fieldNames(model.fieldNames);
        }

        public final Collection<String> getFieldNames() {
            return fieldNames;
        }

        @Override
        public final Builder fieldNames(Collection<String> fieldNames) {
            this.fieldNames = FieldNameListCopier.copy(fieldNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldNames(String... fieldNames) {
            fieldNames(Arrays.asList(fieldNames));
            return this;
        }

        public final void setFieldNames(Collection<String> fieldNames) {
            this.fieldNames = FieldNameListCopier.copy(fieldNames);
        }

        @Override
        public IndexDocumentsResponse build() {
            return new IndexDocumentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
