/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Options for a field that contains an array of 64-bit signed integers. Present if <code>IndexFieldType</code>
 * specifies the field is of type <code>int-array</code>. All options are enabled by default.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IntArrayOptions implements SdkPojo, Serializable, ToCopyableBuilder<IntArrayOptions.Builder, IntArrayOptions> {
    private static final SdkField<Long> DEFAULT_VALUE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DefaultValue").getter(getter(IntArrayOptions::defaultValue)).setter(setter(Builder::defaultValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build()).build();

    private static final SdkField<String> SOURCE_FIELDS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceFields").getter(getter(IntArrayOptions::sourceFields)).setter(setter(Builder::sourceFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceFields").build()).build();

    private static final SdkField<Boolean> FACET_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("FacetEnabled").getter(getter(IntArrayOptions::facetEnabled)).setter(setter(Builder::facetEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FacetEnabled").build()).build();

    private static final SdkField<Boolean> SEARCH_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SearchEnabled").getter(getter(IntArrayOptions::searchEnabled)).setter(setter(Builder::searchEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchEnabled").build()).build();

    private static final SdkField<Boolean> RETURN_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ReturnEnabled").getter(getter(IntArrayOptions::returnEnabled)).setter(setter(Builder::returnEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnEnabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_VALUE_FIELD,
            SOURCE_FIELDS_FIELD, FACET_ENABLED_FIELD, SEARCH_ENABLED_FIELD, RETURN_ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long defaultValue;

    private final String sourceFields;

    private final Boolean facetEnabled;

    private final Boolean searchEnabled;

    private final Boolean returnEnabled;

    private IntArrayOptions(BuilderImpl builder) {
        this.defaultValue = builder.defaultValue;
        this.sourceFields = builder.sourceFields;
        this.facetEnabled = builder.facetEnabled;
        this.searchEnabled = builder.searchEnabled;
        this.returnEnabled = builder.returnEnabled;
    }

    /**
     * A value to use for the field if the field isn't specified for a document.
     * 
     * @return A value to use for the field if the field isn't specified for a document.
     */
    public Long defaultValue() {
        return defaultValue;
    }

    /**
     * <p>
     * A list of source fields to map to the field.
     * </p>
     * 
     * @return A list of source fields to map to the field.
     */
    public String sourceFields() {
        return sourceFields;
    }

    /**
     * <p>
     * Whether facet information can be returned for the field.
     * </p>
     * 
     * @return Whether facet information can be returned for the field.
     */
    public Boolean facetEnabled() {
        return facetEnabled;
    }

    /**
     * <p>
     * Whether the contents of the field are searchable.
     * </p>
     * 
     * @return Whether the contents of the field are searchable.
     */
    public Boolean searchEnabled() {
        return searchEnabled;
    }

    /**
     * <p>
     * Whether the contents of the field can be returned in the search results.
     * </p>
     * 
     * @return Whether the contents of the field can be returned in the search results.
     */
    public Boolean returnEnabled() {
        return returnEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(sourceFields());
        hashCode = 31 * hashCode + Objects.hashCode(facetEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(searchEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(returnEnabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntArrayOptions)) {
            return false;
        }
        IntArrayOptions other = (IntArrayOptions) obj;
        return Objects.equals(defaultValue(), other.defaultValue()) && Objects.equals(sourceFields(), other.sourceFields())
                && Objects.equals(facetEnabled(), other.facetEnabled()) && Objects.equals(searchEnabled(), other.searchEnabled())
                && Objects.equals(returnEnabled(), other.returnEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("IntArrayOptions").add("DefaultValue", defaultValue()).add("SourceFields", sourceFields())
                .add("FacetEnabled", facetEnabled()).add("SearchEnabled", searchEnabled()).add("ReturnEnabled", returnEnabled())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DefaultValue":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        case "SourceFields":
            return Optional.ofNullable(clazz.cast(sourceFields()));
        case "FacetEnabled":
            return Optional.ofNullable(clazz.cast(facetEnabled()));
        case "SearchEnabled":
            return Optional.ofNullable(clazz.cast(searchEnabled()));
        case "ReturnEnabled":
            return Optional.ofNullable(clazz.cast(returnEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IntArrayOptions, T> g) {
        return obj -> g.apply((IntArrayOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IntArrayOptions> {
        /**
         * A value to use for the field if the field isn't specified for a document.
         * 
         * @param defaultValue
         *        A value to use for the field if the field isn't specified for a document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(Long defaultValue);

        /**
         * <p>
         * A list of source fields to map to the field.
         * </p>
         * 
         * @param sourceFields
         *        A list of source fields to map to the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceFields(String sourceFields);

        /**
         * <p>
         * Whether facet information can be returned for the field.
         * </p>
         * 
         * @param facetEnabled
         *        Whether facet information can be returned for the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder facetEnabled(Boolean facetEnabled);

        /**
         * <p>
         * Whether the contents of the field are searchable.
         * </p>
         * 
         * @param searchEnabled
         *        Whether the contents of the field are searchable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchEnabled(Boolean searchEnabled);

        /**
         * <p>
         * Whether the contents of the field can be returned in the search results.
         * </p>
         * 
         * @param returnEnabled
         *        Whether the contents of the field can be returned in the search results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder returnEnabled(Boolean returnEnabled);
    }

    static final class BuilderImpl implements Builder {
        private Long defaultValue;

        private String sourceFields;

        private Boolean facetEnabled;

        private Boolean searchEnabled;

        private Boolean returnEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(IntArrayOptions model) {
            defaultValue(model.defaultValue);
            sourceFields(model.sourceFields);
            facetEnabled(model.facetEnabled);
            searchEnabled(model.searchEnabled);
            returnEnabled(model.returnEnabled);
        }

        public final Long getDefaultValue() {
            return defaultValue;
        }

        @Override
        public final Builder defaultValue(Long defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final void setDefaultValue(Long defaultValue) {
            this.defaultValue = defaultValue;
        }

        public final String getSourceFields() {
            return sourceFields;
        }

        @Override
        public final Builder sourceFields(String sourceFields) {
            this.sourceFields = sourceFields;
            return this;
        }

        public final void setSourceFields(String sourceFields) {
            this.sourceFields = sourceFields;
        }

        public final Boolean getFacetEnabled() {
            return facetEnabled;
        }

        @Override
        public final Builder facetEnabled(Boolean facetEnabled) {
            this.facetEnabled = facetEnabled;
            return this;
        }

        public final void setFacetEnabled(Boolean facetEnabled) {
            this.facetEnabled = facetEnabled;
        }

        public final Boolean getSearchEnabled() {
            return searchEnabled;
        }

        @Override
        public final Builder searchEnabled(Boolean searchEnabled) {
            this.searchEnabled = searchEnabled;
            return this;
        }

        public final void setSearchEnabled(Boolean searchEnabled) {
            this.searchEnabled = searchEnabled;
        }

        public final Boolean getReturnEnabled() {
            return returnEnabled;
        }

        @Override
        public final Builder returnEnabled(Boolean returnEnabled) {
            this.returnEnabled = returnEnabled;
            return this;
        }

        public final void setReturnEnabled(Boolean returnEnabled) {
            this.returnEnabled = returnEnabled;
        }

        @Override
        public IntArrayOptions build() {
            return new IntArrayOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
