/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information for a search suggester. Each suggester has a unique name and specifies the text field you
 * want to use for suggestions. The following options can be configured for a suggester: <code>FuzzyMatching</code>,
 * <code>SortExpression</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Suggester implements SdkPojo, Serializable, ToCopyableBuilder<Suggester.Builder, Suggester> {
    private static final SdkField<String> SUGGESTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SuggesterName").getter(getter(Suggester::suggesterName)).setter(setter(Builder::suggesterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuggesterName").build()).build();

    private static final SdkField<DocumentSuggesterOptions> DOCUMENT_SUGGESTER_OPTIONS_FIELD = SdkField
            .<DocumentSuggesterOptions> builder(MarshallingType.SDK_POJO).memberName("DocumentSuggesterOptions")
            .getter(getter(Suggester::documentSuggesterOptions)).setter(setter(Builder::documentSuggesterOptions))
            .constructor(DocumentSuggesterOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentSuggesterOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUGGESTER_NAME_FIELD,
            DOCUMENT_SUGGESTER_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String suggesterName;

    private final DocumentSuggesterOptions documentSuggesterOptions;

    private Suggester(BuilderImpl builder) {
        this.suggesterName = builder.suggesterName;
        this.documentSuggesterOptions = builder.documentSuggesterOptions;
    }

    /**
     * Returns the value of the SuggesterName property for this object.
     * 
     * @return The value of the SuggesterName property for this object.
     */
    public String suggesterName() {
        return suggesterName;
    }

    /**
     * Returns the value of the DocumentSuggesterOptions property for this object.
     * 
     * @return The value of the DocumentSuggesterOptions property for this object.
     */
    public DocumentSuggesterOptions documentSuggesterOptions() {
        return documentSuggesterOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(suggesterName());
        hashCode = 31 * hashCode + Objects.hashCode(documentSuggesterOptions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Suggester)) {
            return false;
        }
        Suggester other = (Suggester) obj;
        return Objects.equals(suggesterName(), other.suggesterName())
                && Objects.equals(documentSuggesterOptions(), other.documentSuggesterOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Suggester").add("SuggesterName", suggesterName())
                .add("DocumentSuggesterOptions", documentSuggesterOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SuggesterName":
            return Optional.ofNullable(clazz.cast(suggesterName()));
        case "DocumentSuggesterOptions":
            return Optional.ofNullable(clazz.cast(documentSuggesterOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Suggester, T> g) {
        return obj -> g.apply((Suggester) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Suggester> {
        /**
         * Sets the value of the SuggesterName property for this object.
         *
         * @param suggesterName
         *        The new value for the SuggesterName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggesterName(String suggesterName);

        /**
         * Sets the value of the DocumentSuggesterOptions property for this object.
         *
         * @param documentSuggesterOptions
         *        The new value for the DocumentSuggesterOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentSuggesterOptions(DocumentSuggesterOptions documentSuggesterOptions);

        /**
         * Sets the value of the DocumentSuggesterOptions property for this object.
         *
         * This is a convenience that creates an instance of the {@link DocumentSuggesterOptions.Builder} avoiding the
         * need to create one manually via {@link DocumentSuggesterOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link DocumentSuggesterOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #documentSuggesterOptions(DocumentSuggesterOptions)}.
         * 
         * @param documentSuggesterOptions
         *        a consumer that will call methods on {@link DocumentSuggesterOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentSuggesterOptions(DocumentSuggesterOptions)
         */
        default Builder documentSuggesterOptions(Consumer<DocumentSuggesterOptions.Builder> documentSuggesterOptions) {
            return documentSuggesterOptions(DocumentSuggesterOptions.builder().applyMutation(documentSuggesterOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String suggesterName;

        private DocumentSuggesterOptions documentSuggesterOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(Suggester model) {
            suggesterName(model.suggesterName);
            documentSuggesterOptions(model.documentSuggesterOptions);
        }

        public final String getSuggesterName() {
            return suggesterName;
        }

        @Override
        public final Builder suggesterName(String suggesterName) {
            this.suggesterName = suggesterName;
            return this;
        }

        public final void setSuggesterName(String suggesterName) {
            this.suggesterName = suggesterName;
        }

        public final DocumentSuggesterOptions.Builder getDocumentSuggesterOptions() {
            return documentSuggesterOptions != null ? documentSuggesterOptions.toBuilder() : null;
        }

        @Override
        public final Builder documentSuggesterOptions(DocumentSuggesterOptions documentSuggesterOptions) {
            this.documentSuggesterOptions = documentSuggesterOptions;
            return this;
        }

        public final void setDocumentSuggesterOptions(DocumentSuggesterOptions.BuilderImpl documentSuggesterOptions) {
            this.documentSuggesterOptions = documentSuggesterOptions != null ? documentSuggesterOptions.build() : null;
        }

        @Override
        public Suggester build() {
            return new Suggester(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
