/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Options for text field. Present if <code>IndexFieldType</code> specifies the field is of type <code>text</code>. A
 * <code>text</code> field is always searchable. All options are enabled by default.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TextOptions implements SdkPojo, Serializable, ToCopyableBuilder<TextOptions.Builder, TextOptions> {
    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultValue").getter(getter(TextOptions::defaultValue)).setter(setter(Builder::defaultValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build()).build();

    private static final SdkField<String> SOURCE_FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceField").getter(getter(TextOptions::sourceField)).setter(setter(Builder::sourceField))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceField").build()).build();

    private static final SdkField<Boolean> RETURN_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ReturnEnabled").getter(getter(TextOptions::returnEnabled)).setter(setter(Builder::returnEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnEnabled").build()).build();

    private static final SdkField<Boolean> SORT_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SortEnabled").getter(getter(TextOptions::sortEnabled)).setter(setter(Builder::sortEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortEnabled").build()).build();

    private static final SdkField<Boolean> HIGHLIGHT_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("HighlightEnabled").getter(getter(TextOptions::highlightEnabled))
            .setter(setter(Builder::highlightEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HighlightEnabled").build()).build();

    private static final SdkField<String> ANALYSIS_SCHEME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnalysisScheme").getter(getter(TextOptions::analysisScheme)).setter(setter(Builder::analysisScheme))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisScheme").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_VALUE_FIELD,
            SOURCE_FIELD_FIELD, RETURN_ENABLED_FIELD, SORT_ENABLED_FIELD, HIGHLIGHT_ENABLED_FIELD, ANALYSIS_SCHEME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String defaultValue;

    private final String sourceField;

    private final Boolean returnEnabled;

    private final Boolean sortEnabled;

    private final Boolean highlightEnabled;

    private final String analysisScheme;

    private TextOptions(BuilderImpl builder) {
        this.defaultValue = builder.defaultValue;
        this.sourceField = builder.sourceField;
        this.returnEnabled = builder.returnEnabled;
        this.sortEnabled = builder.sortEnabled;
        this.highlightEnabled = builder.highlightEnabled;
        this.analysisScheme = builder.analysisScheme;
    }

    /**
     * A value to use for the field if the field isn't specified for a document.
     * 
     * @return A value to use for the field if the field isn't specified for a document.
     */
    public String defaultValue() {
        return defaultValue;
    }

    /**
     * Returns the value of the SourceField property for this object.
     * 
     * @return The value of the SourceField property for this object.
     */
    public String sourceField() {
        return sourceField;
    }

    /**
     * <p>
     * Whether the contents of the field can be returned in the search results.
     * </p>
     * 
     * @return Whether the contents of the field can be returned in the search results.
     */
    public Boolean returnEnabled() {
        return returnEnabled;
    }

    /**
     * <p>
     * Whether the field can be used to sort the search results.
     * </p>
     * 
     * @return Whether the field can be used to sort the search results.
     */
    public Boolean sortEnabled() {
        return sortEnabled;
    }

    /**
     * <p>
     * Whether highlights can be returned for the field.
     * </p>
     * 
     * @return Whether highlights can be returned for the field.
     */
    public Boolean highlightEnabled() {
        return highlightEnabled;
    }

    /**
     * <p>
     * The name of an analysis scheme for a <code>text</code> field.
     * </p>
     * 
     * @return The name of an analysis scheme for a <code>text</code> field.
     */
    public String analysisScheme() {
        return analysisScheme;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(sourceField());
        hashCode = 31 * hashCode + Objects.hashCode(returnEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(sortEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(highlightEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(analysisScheme());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextOptions)) {
            return false;
        }
        TextOptions other = (TextOptions) obj;
        return Objects.equals(defaultValue(), other.defaultValue()) && Objects.equals(sourceField(), other.sourceField())
                && Objects.equals(returnEnabled(), other.returnEnabled()) && Objects.equals(sortEnabled(), other.sortEnabled())
                && Objects.equals(highlightEnabled(), other.highlightEnabled())
                && Objects.equals(analysisScheme(), other.analysisScheme());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TextOptions").add("DefaultValue", defaultValue()).add("SourceField", sourceField())
                .add("ReturnEnabled", returnEnabled()).add("SortEnabled", sortEnabled())
                .add("HighlightEnabled", highlightEnabled()).add("AnalysisScheme", analysisScheme()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DefaultValue":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        case "SourceField":
            return Optional.ofNullable(clazz.cast(sourceField()));
        case "ReturnEnabled":
            return Optional.ofNullable(clazz.cast(returnEnabled()));
        case "SortEnabled":
            return Optional.ofNullable(clazz.cast(sortEnabled()));
        case "HighlightEnabled":
            return Optional.ofNullable(clazz.cast(highlightEnabled()));
        case "AnalysisScheme":
            return Optional.ofNullable(clazz.cast(analysisScheme()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TextOptions, T> g) {
        return obj -> g.apply((TextOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TextOptions> {
        /**
         * A value to use for the field if the field isn't specified for a document.
         * 
         * @param defaultValue
         *        A value to use for the field if the field isn't specified for a document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(String defaultValue);

        /**
         * Sets the value of the SourceField property for this object.
         *
         * @param sourceField
         *        The new value for the SourceField property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceField(String sourceField);

        /**
         * <p>
         * Whether the contents of the field can be returned in the search results.
         * </p>
         * 
         * @param returnEnabled
         *        Whether the contents of the field can be returned in the search results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder returnEnabled(Boolean returnEnabled);

        /**
         * <p>
         * Whether the field can be used to sort the search results.
         * </p>
         * 
         * @param sortEnabled
         *        Whether the field can be used to sort the search results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortEnabled(Boolean sortEnabled);

        /**
         * <p>
         * Whether highlights can be returned for the field.
         * </p>
         * 
         * @param highlightEnabled
         *        Whether highlights can be returned for the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder highlightEnabled(Boolean highlightEnabled);

        /**
         * <p>
         * The name of an analysis scheme for a <code>text</code> field.
         * </p>
         * 
         * @param analysisScheme
         *        The name of an analysis scheme for a <code>text</code> field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisScheme(String analysisScheme);
    }

    static final class BuilderImpl implements Builder {
        private String defaultValue;

        private String sourceField;

        private Boolean returnEnabled;

        private Boolean sortEnabled;

        private Boolean highlightEnabled;

        private String analysisScheme;

        private BuilderImpl() {
        }

        private BuilderImpl(TextOptions model) {
            defaultValue(model.defaultValue);
            sourceField(model.sourceField);
            returnEnabled(model.returnEnabled);
            sortEnabled(model.sortEnabled);
            highlightEnabled(model.highlightEnabled);
            analysisScheme(model.analysisScheme);
        }

        public final String getDefaultValue() {
            return defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public final String getSourceField() {
            return sourceField;
        }

        @Override
        public final Builder sourceField(String sourceField) {
            this.sourceField = sourceField;
            return this;
        }

        public final void setSourceField(String sourceField) {
            this.sourceField = sourceField;
        }

        public final Boolean getReturnEnabled() {
            return returnEnabled;
        }

        @Override
        public final Builder returnEnabled(Boolean returnEnabled) {
            this.returnEnabled = returnEnabled;
            return this;
        }

        public final void setReturnEnabled(Boolean returnEnabled) {
            this.returnEnabled = returnEnabled;
        }

        public final Boolean getSortEnabled() {
            return sortEnabled;
        }

        @Override
        public final Builder sortEnabled(Boolean sortEnabled) {
            this.sortEnabled = sortEnabled;
            return this;
        }

        public final void setSortEnabled(Boolean sortEnabled) {
            this.sortEnabled = sortEnabled;
        }

        public final Boolean getHighlightEnabled() {
            return highlightEnabled;
        }

        @Override
        public final Builder highlightEnabled(Boolean highlightEnabled) {
            this.highlightEnabled = highlightEnabled;
            return this;
        }

        public final void setHighlightEnabled(Boolean highlightEnabled) {
            this.highlightEnabled = highlightEnabled;
        }

        public final String getAnalysisScheme() {
            return analysisScheme;
        }

        @Override
        public final Builder analysisScheme(String analysisScheme) {
            this.analysisScheme = analysisScheme;
            return this;
        }

        public final void setAnalysisScheme(String analysisScheme) {
            this.analysisScheme = analysisScheme;
        }

        @Override
        public TextOptions build() {
            return new TextOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
