/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of a <code>UpdateDomainEndpointOptions</code> request. Contains the configuration and status of the
 * domain's endpoint options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDomainEndpointOptionsResponse extends CloudSearchResponse implements
        ToCopyableBuilder<UpdateDomainEndpointOptionsResponse.Builder, UpdateDomainEndpointOptionsResponse> {
    private static final SdkField<DomainEndpointOptionsStatus> DOMAIN_ENDPOINT_OPTIONS_FIELD = SdkField
            .<DomainEndpointOptionsStatus> builder(MarshallingType.SDK_POJO).memberName("DomainEndpointOptions")
            .getter(getter(UpdateDomainEndpointOptionsResponse::domainEndpointOptions))
            .setter(setter(Builder::domainEndpointOptions)).constructor(DomainEndpointOptionsStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainEndpointOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(DOMAIN_ENDPOINT_OPTIONS_FIELD));

    private final DomainEndpointOptionsStatus domainEndpointOptions;

    private UpdateDomainEndpointOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.domainEndpointOptions = builder.domainEndpointOptions;
    }

    /**
     * <p>
     * The newly-configured domain endpoint options.
     * </p>
     * 
     * @return The newly-configured domain endpoint options.
     */
    public DomainEndpointOptionsStatus domainEndpointOptions() {
        return domainEndpointOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainEndpointOptions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainEndpointOptionsResponse)) {
            return false;
        }
        UpdateDomainEndpointOptionsResponse other = (UpdateDomainEndpointOptionsResponse) obj;
        return Objects.equals(domainEndpointOptions(), other.domainEndpointOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateDomainEndpointOptionsResponse").add("DomainEndpointOptions", domainEndpointOptions())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainEndpointOptions":
            return Optional.ofNullable(clazz.cast(domainEndpointOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDomainEndpointOptionsResponse, T> g) {
        return obj -> g.apply((UpdateDomainEndpointOptionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudSearchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateDomainEndpointOptionsResponse> {
        /**
         * <p>
         * The newly-configured domain endpoint options.
         * </p>
         * 
         * @param domainEndpointOptions
         *        The newly-configured domain endpoint options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainEndpointOptions(DomainEndpointOptionsStatus domainEndpointOptions);

        /**
         * <p>
         * The newly-configured domain endpoint options.
         * </p>
         * This is a convenience that creates an instance of the {@link DomainEndpointOptionsStatus.Builder} avoiding
         * the need to create one manually via {@link DomainEndpointOptionsStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link DomainEndpointOptionsStatus.Builder#build()} is called
         * immediately and its result is passed to {@link #domainEndpointOptions(DomainEndpointOptionsStatus)}.
         * 
         * @param domainEndpointOptions
         *        a consumer that will call methods on {@link DomainEndpointOptionsStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainEndpointOptions(DomainEndpointOptionsStatus)
         */
        default Builder domainEndpointOptions(Consumer<DomainEndpointOptionsStatus.Builder> domainEndpointOptions) {
            return domainEndpointOptions(DomainEndpointOptionsStatus.builder().applyMutation(domainEndpointOptions).build());
        }
    }

    static final class BuilderImpl extends CloudSearchResponse.BuilderImpl implements Builder {
        private DomainEndpointOptionsStatus domainEndpointOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDomainEndpointOptionsResponse model) {
            super(model);
            domainEndpointOptions(model.domainEndpointOptions);
        }

        public final DomainEndpointOptionsStatus.Builder getDomainEndpointOptions() {
            return domainEndpointOptions != null ? domainEndpointOptions.toBuilder() : null;
        }

        @Override
        public final Builder domainEndpointOptions(DomainEndpointOptionsStatus domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions;
            return this;
        }

        public final void setDomainEndpointOptions(DomainEndpointOptionsStatus.BuilderImpl domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions != null ? domainEndpointOptions.build() : null;
        }

        @Override
        public UpdateDomainEndpointOptionsResponse build() {
            return new UpdateDomainEndpointOptionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
