/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestarconnections.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateHostResponse extends CodeStarConnectionsResponse implements
        ToCopyableBuilder<CreateHostResponse.Builder, CreateHostResponse> {
    private static final SdkField<String> HOST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HostArn").getter(getter(CreateHostResponse::hostArn)).setter(setter(Builder::hostArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_ARN_FIELD));

    private final String hostArn;

    private CreateHostResponse(BuilderImpl builder) {
        super(builder);
        this.hostArn = builder.hostArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the host to be created.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the host to be created.
     */
    public String hostArn() {
        return hostArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hostArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHostResponse)) {
            return false;
        }
        CreateHostResponse other = (CreateHostResponse) obj;
        return Objects.equals(hostArn(), other.hostArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateHostResponse").add("HostArn", hostArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostArn":
            return Optional.ofNullable(clazz.cast(hostArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateHostResponse, T> g) {
        return obj -> g.apply((CreateHostResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeStarConnectionsResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateHostResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the host to be created.
         * </p>
         * 
         * @param hostArn
         *        The Amazon Resource Name (ARN) of the host to be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostArn(String hostArn);
    }

    static final class BuilderImpl extends CodeStarConnectionsResponse.BuilderImpl implements Builder {
        private String hostArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHostResponse model) {
            super(model);
            hostArn(model.hostArn);
        }

        public final String getHostArn() {
            return hostArn;
        }

        @Override
        public final Builder hostArn(String hostArn) {
            this.hostArn = hostArn;
            return this;
        }

        public final void setHostArn(String hostArn) {
            this.hostArn = hostArn;
        }

        @Override
        public CreateHostResponse build() {
            return new CreateHostResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
