/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestarconnections.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The VPC configuration provisioned for the host.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<VpcConfiguration.Builder, VpcConfiguration> {
    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(VpcConfiguration::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubnetIds")
            .getter(getter(VpcConfiguration::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIds")
            .getter(getter(VpcConfiguration::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TLS_CERTIFICATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TlsCertificate").getter(getter(VpcConfiguration::tlsCertificate))
            .setter(setter(Builder::tlsCertificate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TlsCertificate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ID_FIELD,
            SUBNET_IDS_FIELD, SECURITY_GROUP_IDS_FIELD, TLS_CERTIFICATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String vpcId;

    private final List<String> subnetIds;

    private final List<String> securityGroupIds;

    private final String tlsCertificate;

    private VpcConfiguration(BuilderImpl builder) {
        this.vpcId = builder.vpcId;
        this.subnetIds = builder.subnetIds;
        this.securityGroupIds = builder.securityGroupIds;
        this.tlsCertificate = builder.tlsCertificate;
    }

    /**
     * <p>
     * The ID of the Amazon VPC connected to the infrastructure where your provider type is installed.
     * </p>
     * 
     * @return The ID of the Amazon VPC connected to the infrastructure where your provider type is installed.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * Returns true if the SubnetIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ID of the subnet or subnets associated with the Amazon VPC connected to the infrastructure where your
     * provider type is installed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSubnetIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The ID of the subnet or subnets associated with the Amazon VPC connected to the infrastructure where your
     *         provider type is installed.
     */
    public List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * Returns true if the SecurityGroupIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ID of the security group or security groups associated with the Amazon VPC connected to the infrastructure
     * where your provider type is installed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroupIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The ID of the security group or security groups associated with the Amazon VPC connected to the
     *         infrastructure where your provider type is installed.
     */
    public List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * The value of the Transport Layer Security (TLS) certificate associated with the infrastructure where your
     * provider type is installed.
     * </p>
     * 
     * @return The value of the Transport Layer Security (TLS) certificate associated with the infrastructure where your
     *         provider type is installed.
     */
    public String tlsCertificate() {
        return tlsCertificate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(subnetIds());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(tlsCertificate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcConfiguration)) {
            return false;
        }
        VpcConfiguration other = (VpcConfiguration) obj;
        return Objects.equals(vpcId(), other.vpcId()) && Objects.equals(subnetIds(), other.subnetIds())
                && Objects.equals(securityGroupIds(), other.securityGroupIds())
                && Objects.equals(tlsCertificate(), other.tlsCertificate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("VpcConfiguration").add("VpcId", vpcId()).add("SubnetIds", subnetIds())
                .add("SecurityGroupIds", securityGroupIds()).add("TlsCertificate", tlsCertificate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "TlsCertificate":
            return Optional.ofNullable(clazz.cast(tlsCertificate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VpcConfiguration, T> g) {
        return obj -> g.apply((VpcConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcConfiguration> {
        /**
         * <p>
         * The ID of the Amazon VPC connected to the infrastructure where your provider type is installed.
         * </p>
         * 
         * @param vpcId
         *        The ID of the Amazon VPC connected to the infrastructure where your provider type is installed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The ID of the subnet or subnets associated with the Amazon VPC connected to the infrastructure where your
         * provider type is installed.
         * </p>
         * 
         * @param subnetIds
         *        The ID of the subnet or subnets associated with the Amazon VPC connected to the infrastructure where
         *        your provider type is installed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * The ID of the subnet or subnets associated with the Amazon VPC connected to the infrastructure where your
         * provider type is installed.
         * </p>
         * 
         * @param subnetIds
         *        The ID of the subnet or subnets associated with the Amazon VPC connected to the infrastructure where
         *        your provider type is installed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * The ID of the security group or security groups associated with the Amazon VPC connected to the
         * infrastructure where your provider type is installed.
         * </p>
         * 
         * @param securityGroupIds
         *        The ID of the security group or security groups associated with the Amazon VPC connected to the
         *        infrastructure where your provider type is installed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * The ID of the security group or security groups associated with the Amazon VPC connected to the
         * infrastructure where your provider type is installed.
         * </p>
         * 
         * @param securityGroupIds
         *        The ID of the security group or security groups associated with the Amazon VPC connected to the
         *        infrastructure where your provider type is installed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * The value of the Transport Layer Security (TLS) certificate associated with the infrastructure where your
         * provider type is installed.
         * </p>
         * 
         * @param tlsCertificate
         *        The value of the Transport Layer Security (TLS) certificate associated with the infrastructure where
         *        your provider type is installed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tlsCertificate(String tlsCertificate);
    }

    static final class BuilderImpl implements Builder {
        private String vpcId;

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String tlsCertificate;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcConfiguration model) {
            vpcId(model.vpcId);
            subnetIds(model.subnetIds);
            securityGroupIds(model.securityGroupIds);
            tlsCertificate(model.tlsCertificate);
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Collection<String> getSubnetIds() {
            return subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
        }

        public final Collection<String> getSecurityGroupIds() {
            return securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
        }

        public final String getTlsCertificate() {
            return tlsCertificate;
        }

        @Override
        public final Builder tlsCertificate(String tlsCertificate) {
            this.tlsCertificate = tlsCertificate;
            return this;
        }

        public final void setTlsCertificate(String tlsCertificate) {
            this.tlsCertificate = tlsCertificate;
        }

        @Override
        public VpcConfiguration build() {
            return new VpcConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
