/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A container for identity provider details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProviderDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<ProviderDescription.Builder, ProviderDescription> {
    private static final SdkField<String> PROVIDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProviderName").getter(getter(ProviderDescription::providerName)).setter(setter(Builder::providerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderName").build()).build();

    private static final SdkField<String> PROVIDER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProviderType").getter(getter(ProviderDescription::providerTypeAsString))
            .setter(setter(Builder::providerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderType").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedDate").getter(getter(ProviderDescription::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDate").getter(getter(ProviderDescription::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDER_NAME_FIELD,
            PROVIDER_TYPE_FIELD, LAST_MODIFIED_DATE_FIELD, CREATION_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String providerName;

    private final String providerType;

    private final Instant lastModifiedDate;

    private final Instant creationDate;

    private ProviderDescription(BuilderImpl builder) {
        this.providerName = builder.providerName;
        this.providerType = builder.providerType;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.creationDate = builder.creationDate;
    }

    /**
     * <p>
     * The identity provider name.
     * </p>
     * 
     * @return The identity provider name.
     */
    public String providerName() {
        return providerName;
    }

    /**
     * <p>
     * The identity provider type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #providerType} will
     * return {@link IdentityProviderTypeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #providerTypeAsString}.
     * </p>
     * 
     * @return The identity provider type.
     * @see IdentityProviderTypeType
     */
    public IdentityProviderTypeType providerType() {
        return IdentityProviderTypeType.fromValue(providerType);
    }

    /**
     * <p>
     * The identity provider type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #providerType} will
     * return {@link IdentityProviderTypeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #providerTypeAsString}.
     * </p>
     * 
     * @return The identity provider type.
     * @see IdentityProviderTypeType
     */
    public String providerTypeAsString() {
        return providerType;
    }

    /**
     * <p>
     * The date the provider was last modified.
     * </p>
     * 
     * @return The date the provider was last modified.
     */
    public Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The date the provider was added to the user pool.
     * </p>
     * 
     * @return The date the provider was added to the user pool.
     */
    public Instant creationDate() {
        return creationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(providerName());
        hashCode = 31 * hashCode + Objects.hashCode(providerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProviderDescription)) {
            return false;
        }
        ProviderDescription other = (ProviderDescription) obj;
        return Objects.equals(providerName(), other.providerName())
                && Objects.equals(providerTypeAsString(), other.providerTypeAsString())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(creationDate(), other.creationDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ProviderDescription").add("ProviderName", providerName())
                .add("ProviderType", providerTypeAsString()).add("LastModifiedDate", lastModifiedDate())
                .add("CreationDate", creationDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProviderName":
            return Optional.ofNullable(clazz.cast(providerName()));
        case "ProviderType":
            return Optional.ofNullable(clazz.cast(providerTypeAsString()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProviderDescription, T> g) {
        return obj -> g.apply((ProviderDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProviderDescription> {
        /**
         * <p>
         * The identity provider name.
         * </p>
         * 
         * @param providerName
         *        The identity provider name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerName(String providerName);

        /**
         * <p>
         * The identity provider type.
         * </p>
         * 
         * @param providerType
         *        The identity provider type.
         * @see IdentityProviderTypeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityProviderTypeType
         */
        Builder providerType(String providerType);

        /**
         * <p>
         * The identity provider type.
         * </p>
         * 
         * @param providerType
         *        The identity provider type.
         * @see IdentityProviderTypeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityProviderTypeType
         */
        Builder providerType(IdentityProviderTypeType providerType);

        /**
         * <p>
         * The date the provider was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date the provider was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);

        /**
         * <p>
         * The date the provider was added to the user pool.
         * </p>
         * 
         * @param creationDate
         *        The date the provider was added to the user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);
    }

    static final class BuilderImpl implements Builder {
        private String providerName;

        private String providerType;

        private Instant lastModifiedDate;

        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ProviderDescription model) {
            providerName(model.providerName);
            providerType(model.providerType);
            lastModifiedDate(model.lastModifiedDate);
            creationDate(model.creationDate);
        }

        public final String getProviderName() {
            return providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        public final String getProviderType() {
            return providerType;
        }

        @Override
        public final Builder providerType(String providerType) {
            this.providerType = providerType;
            return this;
        }

        @Override
        public final Builder providerType(IdentityProviderTypeType providerType) {
            this.providerType(providerType == null ? null : providerType.toString());
            return this;
        }

        public final void setProviderType(String providerType) {
            this.providerType = providerType;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public ProviderDescription build() {
            return new ProviderDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
