/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBgpPeerRequest extends DirectConnectRequest implements
        ToCopyableBuilder<CreateBgpPeerRequest.Builder, CreateBgpPeerRequest> {
    private static final SdkField<String> VIRTUAL_INTERFACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("virtualInterfaceId").getter(getter(CreateBgpPeerRequest::virtualInterfaceId))
            .setter(setter(Builder::virtualInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualInterfaceId").build())
            .build();

    private static final SdkField<NewBGPPeer> NEW_BGP_PEER_FIELD = SdkField.<NewBGPPeer> builder(MarshallingType.SDK_POJO)
            .memberName("newBGPPeer").getter(getter(CreateBgpPeerRequest::newBGPPeer)).setter(setter(Builder::newBGPPeer))
            .constructor(NewBGPPeer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newBGPPeer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_INTERFACE_ID_FIELD,
            NEW_BGP_PEER_FIELD));

    private final String virtualInterfaceId;

    private final NewBGPPeer newBGPPeer;

    private CreateBgpPeerRequest(BuilderImpl builder) {
        super(builder);
        this.virtualInterfaceId = builder.virtualInterfaceId;
        this.newBGPPeer = builder.newBGPPeer;
    }

    /**
     * <p>
     * The ID of the virtual interface.
     * </p>
     * 
     * @return The ID of the virtual interface.
     */
    public String virtualInterfaceId() {
        return virtualInterfaceId;
    }

    /**
     * <p>
     * Information about the BGP peer.
     * </p>
     * 
     * @return Information about the BGP peer.
     */
    public NewBGPPeer newBGPPeer() {
        return newBGPPeer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(virtualInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(newBGPPeer());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBgpPeerRequest)) {
            return false;
        }
        CreateBgpPeerRequest other = (CreateBgpPeerRequest) obj;
        return Objects.equals(virtualInterfaceId(), other.virtualInterfaceId())
                && Objects.equals(newBGPPeer(), other.newBGPPeer());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateBgpPeerRequest").add("VirtualInterfaceId", virtualInterfaceId())
                .add("NewBGPPeer", newBGPPeer()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "virtualInterfaceId":
            return Optional.ofNullable(clazz.cast(virtualInterfaceId()));
        case "newBGPPeer":
            return Optional.ofNullable(clazz.cast(newBGPPeer()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBgpPeerRequest, T> g) {
        return obj -> g.apply((CreateBgpPeerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateBgpPeerRequest> {
        /**
         * <p>
         * The ID of the virtual interface.
         * </p>
         * 
         * @param virtualInterfaceId
         *        The ID of the virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualInterfaceId(String virtualInterfaceId);

        /**
         * <p>
         * Information about the BGP peer.
         * </p>
         * 
         * @param newBGPPeer
         *        Information about the BGP peer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newBGPPeer(NewBGPPeer newBGPPeer);

        /**
         * <p>
         * Information about the BGP peer.
         * </p>
         * This is a convenience that creates an instance of the {@link NewBGPPeer.Builder} avoiding the need to create
         * one manually via {@link NewBGPPeer#builder()}.
         *
         * When the {@link Consumer} completes, {@link NewBGPPeer.Builder#build()} is called immediately and its result
         * is passed to {@link #newBGPPeer(NewBGPPeer)}.
         * 
         * @param newBGPPeer
         *        a consumer that will call methods on {@link NewBGPPeer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #newBGPPeer(NewBGPPeer)
         */
        default Builder newBGPPeer(Consumer<NewBGPPeer.Builder> newBGPPeer) {
            return newBGPPeer(NewBGPPeer.builder().applyMutation(newBGPPeer).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectConnectRequest.BuilderImpl implements Builder {
        private String virtualInterfaceId;

        private NewBGPPeer newBGPPeer;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBgpPeerRequest model) {
            super(model);
            virtualInterfaceId(model.virtualInterfaceId);
            newBGPPeer(model.newBGPPeer);
        }

        public final String getVirtualInterfaceId() {
            return virtualInterfaceId;
        }

        @Override
        public final Builder virtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
            return this;
        }

        public final void setVirtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
        }

        public final NewBGPPeer.Builder getNewBGPPeer() {
            return newBGPPeer != null ? newBGPPeer.toBuilder() : null;
        }

        @Override
        public final Builder newBGPPeer(NewBGPPeer newBGPPeer) {
            this.newBGPPeer = newBGPPeer;
            return this;
        }

        public final void setNewBGPPeer(NewBGPPeer.BuilderImpl newBGPPeer) {
            this.newBGPPeer = newBGPPeer != null ? newBGPPeer.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBgpPeerRequest build() {
            return new CreateBgpPeerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
