/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteInterconnectResponse extends DirectConnectResponse implements
        ToCopyableBuilder<DeleteInterconnectResponse.Builder, DeleteInterconnectResponse> {
    private static final SdkField<String> INTERCONNECT_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("interconnectState").getter(getter(DeleteInterconnectResponse::interconnectStateAsString))
            .setter(setter(Builder::interconnectState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interconnectState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERCONNECT_STATE_FIELD));

    private final String interconnectState;

    private DeleteInterconnectResponse(BuilderImpl builder) {
        super(builder);
        this.interconnectState = builder.interconnectState;
    }

    /**
     * <p>
     * The state of the interconnect. The following are the possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>requested</code>: The initial state of an interconnect. The interconnect stays in the requested state until
     * the Letter of Authorization (LOA) is sent to the customer.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pending</code>: The interconnect is approved, and is being initialized.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>available</code>: The network link is up, and the interconnect is ready for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>down</code>: The network link is down.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleting</code>: The interconnect is being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleted</code>: The interconnect is deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>unknown</code>: The state of the interconnect is not available.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interconnectState}
     * will return {@link InterconnectState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #interconnectStateAsString}.
     * </p>
     * 
     * @return The state of the interconnect. The following are the possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>requested</code>: The initial state of an interconnect. The interconnect stays in the requested
     *         state until the Letter of Authorization (LOA) is sent to the customer.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pending</code>: The interconnect is approved, and is being initialized.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>available</code>: The network link is up, and the interconnect is ready for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>down</code>: The network link is down.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleting</code>: The interconnect is being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleted</code>: The interconnect is deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>unknown</code>: The state of the interconnect is not available.
     *         </p>
     *         </li>
     * @see InterconnectState
     */
    public InterconnectState interconnectState() {
        return InterconnectState.fromValue(interconnectState);
    }

    /**
     * <p>
     * The state of the interconnect. The following are the possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>requested</code>: The initial state of an interconnect. The interconnect stays in the requested state until
     * the Letter of Authorization (LOA) is sent to the customer.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pending</code>: The interconnect is approved, and is being initialized.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>available</code>: The network link is up, and the interconnect is ready for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>down</code>: The network link is down.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleting</code>: The interconnect is being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleted</code>: The interconnect is deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>unknown</code>: The state of the interconnect is not available.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interconnectState}
     * will return {@link InterconnectState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #interconnectStateAsString}.
     * </p>
     * 
     * @return The state of the interconnect. The following are the possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>requested</code>: The initial state of an interconnect. The interconnect stays in the requested
     *         state until the Letter of Authorization (LOA) is sent to the customer.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pending</code>: The interconnect is approved, and is being initialized.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>available</code>: The network link is up, and the interconnect is ready for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>down</code>: The network link is down.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleting</code>: The interconnect is being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleted</code>: The interconnect is deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>unknown</code>: The state of the interconnect is not available.
     *         </p>
     *         </li>
     * @see InterconnectState
     */
    public String interconnectStateAsString() {
        return interconnectState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(interconnectStateAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteInterconnectResponse)) {
            return false;
        }
        DeleteInterconnectResponse other = (DeleteInterconnectResponse) obj;
        return Objects.equals(interconnectStateAsString(), other.interconnectStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteInterconnectResponse").add("InterconnectState", interconnectStateAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "interconnectState":
            return Optional.ofNullable(clazz.cast(interconnectStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteInterconnectResponse, T> g) {
        return obj -> g.apply((DeleteInterconnectResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteInterconnectResponse> {
        /**
         * <p>
         * The state of the interconnect. The following are the possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>requested</code>: The initial state of an interconnect. The interconnect stays in the requested state
         * until the Letter of Authorization (LOA) is sent to the customer.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pending</code>: The interconnect is approved, and is being initialized.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>available</code>: The network link is up, and the interconnect is ready for use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>down</code>: The network link is down.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleting</code>: The interconnect is being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleted</code>: The interconnect is deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>unknown</code>: The state of the interconnect is not available.
         * </p>
         * </li>
         * </ul>
         * 
         * @param interconnectState
         *        The state of the interconnect. The following are the possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>requested</code>: The initial state of an interconnect. The interconnect stays in the requested
         *        state until the Letter of Authorization (LOA) is sent to the customer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pending</code>: The interconnect is approved, and is being initialized.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>available</code>: The network link is up, and the interconnect is ready for use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>down</code>: The network link is down.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleting</code>: The interconnect is being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleted</code>: The interconnect is deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>unknown</code>: The state of the interconnect is not available.
         *        </p>
         *        </li>
         * @see InterconnectState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InterconnectState
         */
        Builder interconnectState(String interconnectState);

        /**
         * <p>
         * The state of the interconnect. The following are the possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>requested</code>: The initial state of an interconnect. The interconnect stays in the requested state
         * until the Letter of Authorization (LOA) is sent to the customer.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pending</code>: The interconnect is approved, and is being initialized.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>available</code>: The network link is up, and the interconnect is ready for use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>down</code>: The network link is down.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleting</code>: The interconnect is being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleted</code>: The interconnect is deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>unknown</code>: The state of the interconnect is not available.
         * </p>
         * </li>
         * </ul>
         * 
         * @param interconnectState
         *        The state of the interconnect. The following are the possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>requested</code>: The initial state of an interconnect. The interconnect stays in the requested
         *        state until the Letter of Authorization (LOA) is sent to the customer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pending</code>: The interconnect is approved, and is being initialized.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>available</code>: The network link is up, and the interconnect is ready for use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>down</code>: The network link is down.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleting</code>: The interconnect is being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleted</code>: The interconnect is deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>unknown</code>: The state of the interconnect is not available.
         *        </p>
         *        </li>
         * @see InterconnectState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InterconnectState
         */
        Builder interconnectState(InterconnectState interconnectState);
    }

    static final class BuilderImpl extends DirectConnectResponse.BuilderImpl implements Builder {
        private String interconnectState;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteInterconnectResponse model) {
            super(model);
            interconnectState(model.interconnectState);
        }

        public final String getInterconnectState() {
            return interconnectState;
        }

        @Override
        public final Builder interconnectState(String interconnectState) {
            this.interconnectState = interconnectState;
            return this;
        }

        @Override
        public final Builder interconnectState(InterconnectState interconnectState) {
            this.interconnectState(interconnectState == null ? null : interconnectState.toString());
            return this;
        }

        public final void setInterconnectState(String interconnectState) {
            this.interconnectState = interconnectState;
        }

        @Override
        public DeleteInterconnectResponse build() {
            return new DeleteInterconnectResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
