/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDirectConnectGatewaysResponse extends DirectConnectResponse implements
        ToCopyableBuilder<DescribeDirectConnectGatewaysResponse.Builder, DescribeDirectConnectGatewaysResponse> {
    private static final SdkField<List<DirectConnectGateway>> DIRECT_CONNECT_GATEWAYS_FIELD = SdkField
            .<List<DirectConnectGateway>> builder(MarshallingType.LIST)
            .memberName("directConnectGateways")
            .getter(getter(DescribeDirectConnectGatewaysResponse::directConnectGateways))
            .setter(setter(Builder::directConnectGateways))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directConnectGateways").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DirectConnectGateway> builder(MarshallingType.SDK_POJO)
                                            .constructor(DirectConnectGateway::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeDirectConnectGatewaysResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECT_CONNECT_GATEWAYS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<DirectConnectGateway> directConnectGateways;

    private final String nextToken;

    private DescribeDirectConnectGatewaysResponse(BuilderImpl builder) {
        super(builder);
        this.directConnectGateways = builder.directConnectGateways;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the DirectConnectGateways property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasDirectConnectGateways() {
        return directConnectGateways != null && !(directConnectGateways instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Direct Connect gateways.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDirectConnectGateways()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Direct Connect gateways.
     */
    public List<DirectConnectGateway> directConnectGateways() {
        return directConnectGateways;
    }

    /**
     * <p>
     * The token to retrieve the next page.
     * </p>
     * 
     * @return The token to retrieve the next page.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directConnectGateways());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDirectConnectGatewaysResponse)) {
            return false;
        }
        DescribeDirectConnectGatewaysResponse other = (DescribeDirectConnectGatewaysResponse) obj;
        return Objects.equals(directConnectGateways(), other.directConnectGateways())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeDirectConnectGatewaysResponse").add("DirectConnectGateways", directConnectGateways())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "directConnectGateways":
            return Optional.ofNullable(clazz.cast(directConnectGateways()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDirectConnectGatewaysResponse, T> g) {
        return obj -> g.apply((DescribeDirectConnectGatewaysResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDirectConnectGatewaysResponse> {
        /**
         * <p>
         * The Direct Connect gateways.
         * </p>
         * 
         * @param directConnectGateways
         *        The Direct Connect gateways.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directConnectGateways(Collection<DirectConnectGateway> directConnectGateways);

        /**
         * <p>
         * The Direct Connect gateways.
         * </p>
         * 
         * @param directConnectGateways
         *        The Direct Connect gateways.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directConnectGateways(DirectConnectGateway... directConnectGateways);

        /**
         * <p>
         * The Direct Connect gateways.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DirectConnectGateway>.Builder} avoiding the
         * need to create one manually via {@link List<DirectConnectGateway>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DirectConnectGateway>.Builder#build()} is called immediately
         * and its result is passed to {@link #directConnectGateways(List<DirectConnectGateway>)}.
         * 
         * @param directConnectGateways
         *        a consumer that will call methods on {@link List<DirectConnectGateway>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #directConnectGateways(List<DirectConnectGateway>)
         */
        Builder directConnectGateways(Consumer<DirectConnectGateway.Builder>... directConnectGateways);

        /**
         * <p>
         * The token to retrieve the next page.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DirectConnectResponse.BuilderImpl implements Builder {
        private List<DirectConnectGateway> directConnectGateways = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDirectConnectGatewaysResponse model) {
            super(model);
            directConnectGateways(model.directConnectGateways);
            nextToken(model.nextToken);
        }

        public final Collection<DirectConnectGateway.Builder> getDirectConnectGateways() {
            return directConnectGateways != null ? directConnectGateways.stream().map(DirectConnectGateway::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder directConnectGateways(Collection<DirectConnectGateway> directConnectGateways) {
            this.directConnectGateways = DirectConnectGatewayListCopier.copy(directConnectGateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directConnectGateways(DirectConnectGateway... directConnectGateways) {
            directConnectGateways(Arrays.asList(directConnectGateways));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directConnectGateways(Consumer<DirectConnectGateway.Builder>... directConnectGateways) {
            directConnectGateways(Stream.of(directConnectGateways)
                    .map(c -> DirectConnectGateway.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDirectConnectGateways(Collection<DirectConnectGateway.BuilderImpl> directConnectGateways) {
            this.directConnectGateways = DirectConnectGatewayListCopier.copyFromBuilder(directConnectGateways);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeDirectConnectGatewaysResponse build() {
            return new DescribeDirectConnectGatewaysResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
