/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInterconnectsResponse extends DirectConnectResponse implements
        ToCopyableBuilder<DescribeInterconnectsResponse.Builder, DescribeInterconnectsResponse> {
    private static final SdkField<List<Interconnect>> INTERCONNECTS_FIELD = SdkField
            .<List<Interconnect>> builder(MarshallingType.LIST)
            .memberName("interconnects")
            .getter(getter(DescribeInterconnectsResponse::interconnects))
            .setter(setter(Builder::interconnects))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interconnects").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Interconnect> builder(MarshallingType.SDK_POJO)
                                            .constructor(Interconnect::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERCONNECTS_FIELD));

    private final List<Interconnect> interconnects;

    private DescribeInterconnectsResponse(BuilderImpl builder) {
        super(builder);
        this.interconnects = builder.interconnects;
    }

    /**
     * Returns true if the Interconnects property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasInterconnects() {
        return interconnects != null && !(interconnects instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The interconnects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInterconnects()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The interconnects.
     */
    public List<Interconnect> interconnects() {
        return interconnects;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(interconnects());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInterconnectsResponse)) {
            return false;
        }
        DescribeInterconnectsResponse other = (DescribeInterconnectsResponse) obj;
        return Objects.equals(interconnects(), other.interconnects());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeInterconnectsResponse").add("Interconnects", interconnects()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "interconnects":
            return Optional.ofNullable(clazz.cast(interconnects()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInterconnectsResponse, T> g) {
        return obj -> g.apply((DescribeInterconnectsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeInterconnectsResponse> {
        /**
         * <p>
         * The interconnects.
         * </p>
         * 
         * @param interconnects
         *        The interconnects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interconnects(Collection<Interconnect> interconnects);

        /**
         * <p>
         * The interconnects.
         * </p>
         * 
         * @param interconnects
         *        The interconnects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interconnects(Interconnect... interconnects);

        /**
         * <p>
         * The interconnects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Interconnect>.Builder} avoiding the need to
         * create one manually via {@link List<Interconnect>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Interconnect>.Builder#build()} is called immediately and its
         * result is passed to {@link #interconnects(List<Interconnect>)}.
         * 
         * @param interconnects
         *        a consumer that will call methods on {@link List<Interconnect>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #interconnects(List<Interconnect>)
         */
        Builder interconnects(Consumer<Interconnect.Builder>... interconnects);
    }

    static final class BuilderImpl extends DirectConnectResponse.BuilderImpl implements Builder {
        private List<Interconnect> interconnects = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInterconnectsResponse model) {
            super(model);
            interconnects(model.interconnects);
        }

        public final Collection<Interconnect.Builder> getInterconnects() {
            return interconnects != null ? interconnects.stream().map(Interconnect::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder interconnects(Collection<Interconnect> interconnects) {
            this.interconnects = InterconnectListCopier.copy(interconnects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder interconnects(Interconnect... interconnects) {
            interconnects(Arrays.asList(interconnects));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder interconnects(Consumer<Interconnect.Builder>... interconnects) {
            interconnects(Stream.of(interconnects).map(c -> Interconnect.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInterconnects(Collection<Interconnect.BuilderImpl> interconnects) {
            this.interconnects = InterconnectListCopier.copyFromBuilder(interconnects);
        }

        @Override
        public DescribeInterconnectsResponse build() {
            return new DescribeInterconnectsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
