/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLagsResponse extends DirectConnectResponse implements
        ToCopyableBuilder<DescribeLagsResponse.Builder, DescribeLagsResponse> {
    private static final SdkField<List<Lag>> LAGS_FIELD = SdkField
            .<List<Lag>> builder(MarshallingType.LIST)
            .memberName("lags")
            .getter(getter(DescribeLagsResponse::lags))
            .setter(setter(Builder::lags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Lag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Lag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAGS_FIELD));

    private final List<Lag> lags;

    private DescribeLagsResponse(BuilderImpl builder) {
        super(builder);
        this.lags = builder.lags;
    }

    /**
     * Returns true if the Lags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasLags() {
        return lags != null && !(lags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The LAGs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The LAGs.
     */
    public List<Lag> lags() {
        return lags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(lags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLagsResponse)) {
            return false;
        }
        DescribeLagsResponse other = (DescribeLagsResponse) obj;
        return Objects.equals(lags(), other.lags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeLagsResponse").add("Lags", lags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lags":
            return Optional.ofNullable(clazz.cast(lags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLagsResponse, T> g) {
        return obj -> g.apply((DescribeLagsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeLagsResponse> {
        /**
         * <p>
         * The LAGs.
         * </p>
         * 
         * @param lags
         *        The LAGs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lags(Collection<Lag> lags);

        /**
         * <p>
         * The LAGs.
         * </p>
         * 
         * @param lags
         *        The LAGs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lags(Lag... lags);

        /**
         * <p>
         * The LAGs.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Lag>.Builder} avoiding the need to create
         * one manually via {@link List<Lag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Lag>.Builder#build()} is called immediately and its result
         * is passed to {@link #lags(List<Lag>)}.
         * 
         * @param lags
         *        a consumer that will call methods on {@link List<Lag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lags(List<Lag>)
         */
        Builder lags(Consumer<Lag.Builder>... lags);
    }

    static final class BuilderImpl extends DirectConnectResponse.BuilderImpl implements Builder {
        private List<Lag> lags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLagsResponse model) {
            super(model);
            lags(model.lags);
        }

        public final Collection<Lag.Builder> getLags() {
            return lags != null ? lags.stream().map(Lag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder lags(Collection<Lag> lags) {
            this.lags = LagListCopier.copy(lags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lags(Lag... lags) {
            lags(Arrays.asList(lags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lags(Consumer<Lag.Builder>... lags) {
            lags(Stream.of(lags).map(c -> Lag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLags(Collection<Lag.BuilderImpl> lags) {
            this.lags = LagListCopier.copyFromBuilder(lags);
        }

        @Override
        public DescribeLagsResponse build() {
            return new DescribeLagsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
