/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLocationsResponse extends DirectConnectResponse implements
        ToCopyableBuilder<DescribeLocationsResponse.Builder, DescribeLocationsResponse> {
    private static final SdkField<List<Location>> LOCATIONS_FIELD = SdkField
            .<List<Location>> builder(MarshallingType.LIST)
            .memberName("locations")
            .getter(getter(DescribeLocationsResponse::locations))
            .setter(setter(Builder::locations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Location> builder(MarshallingType.SDK_POJO)
                                            .constructor(Location::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATIONS_FIELD));

    private final List<Location> locations;

    private DescribeLocationsResponse(BuilderImpl builder) {
        super(builder);
        this.locations = builder.locations;
    }

    /**
     * Returns true if the Locations property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasLocations() {
        return locations != null && !(locations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The locations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLocations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The locations.
     */
    public List<Location> locations() {
        return locations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(locations());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLocationsResponse)) {
            return false;
        }
        DescribeLocationsResponse other = (DescribeLocationsResponse) obj;
        return Objects.equals(locations(), other.locations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeLocationsResponse").add("Locations", locations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "locations":
            return Optional.ofNullable(clazz.cast(locations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLocationsResponse, T> g) {
        return obj -> g.apply((DescribeLocationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeLocationsResponse> {
        /**
         * <p>
         * The locations.
         * </p>
         * 
         * @param locations
         *        The locations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locations(Collection<Location> locations);

        /**
         * <p>
         * The locations.
         * </p>
         * 
         * @param locations
         *        The locations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locations(Location... locations);

        /**
         * <p>
         * The locations.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Location>.Builder} avoiding the need to
         * create one manually via {@link List<Location>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Location>.Builder#build()} is called immediately and its
         * result is passed to {@link #locations(List<Location>)}.
         * 
         * @param locations
         *        a consumer that will call methods on {@link List<Location>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #locations(List<Location>)
         */
        Builder locations(Consumer<Location.Builder>... locations);
    }

    static final class BuilderImpl extends DirectConnectResponse.BuilderImpl implements Builder {
        private List<Location> locations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLocationsResponse model) {
            super(model);
            locations(model.locations);
        }

        public final Collection<Location.Builder> getLocations() {
            return locations != null ? locations.stream().map(Location::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder locations(Collection<Location> locations) {
            this.locations = LocationListCopier.copy(locations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locations(Location... locations) {
            locations(Arrays.asList(locations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locations(Consumer<Location.Builder>... locations) {
            locations(Stream.of(locations).map(c -> Location.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLocations(Collection<Location.BuilderImpl> locations) {
            this.locations = LocationListCopier.copyFromBuilder(locations);
        }

        @Override
        public DescribeLocationsResponse build() {
            return new DescribeLocationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
