/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the proposal request to attach a virtual private gateway to a Direct Connect gateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DirectConnectGatewayAssociationProposal implements SdkPojo, Serializable,
        ToCopyableBuilder<DirectConnectGatewayAssociationProposal.Builder, DirectConnectGatewayAssociationProposal> {
    private static final SdkField<String> PROPOSAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("proposalId").getter(getter(DirectConnectGatewayAssociationProposal::proposalId))
            .setter(setter(Builder::proposalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("proposalId").build()).build();

    private static final SdkField<String> DIRECT_CONNECT_GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("directConnectGatewayId").getter(getter(DirectConnectGatewayAssociationProposal::directConnectGatewayId))
            .setter(setter(Builder::directConnectGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directConnectGatewayId").build())
            .build();

    private static final SdkField<String> DIRECT_CONNECT_GATEWAY_OWNER_ACCOUNT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("directConnectGatewayOwnerAccount")
            .getter(getter(DirectConnectGatewayAssociationProposal::directConnectGatewayOwnerAccount))
            .setter(setter(Builder::directConnectGatewayOwnerAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directConnectGatewayOwnerAccount")
                    .build()).build();

    private static final SdkField<String> PROPOSAL_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("proposalState").getter(getter(DirectConnectGatewayAssociationProposal::proposalStateAsString))
            .setter(setter(Builder::proposalState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("proposalState").build()).build();

    private static final SdkField<AssociatedGateway> ASSOCIATED_GATEWAY_FIELD = SdkField
            .<AssociatedGateway> builder(MarshallingType.SDK_POJO).memberName("associatedGateway")
            .getter(getter(DirectConnectGatewayAssociationProposal::associatedGateway))
            .setter(setter(Builder::associatedGateway)).constructor(AssociatedGateway::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedGateway").build()).build();

    private static final SdkField<List<RouteFilterPrefix>> EXISTING_ALLOWED_PREFIXES_TO_DIRECT_CONNECT_GATEWAY_FIELD = SdkField
            .<List<RouteFilterPrefix>> builder(MarshallingType.LIST)
            .memberName("existingAllowedPrefixesToDirectConnectGateway")
            .getter(getter(DirectConnectGatewayAssociationProposal::existingAllowedPrefixesToDirectConnectGateway))
            .setter(setter(Builder::existingAllowedPrefixesToDirectConnectGateway))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("existingAllowedPrefixesToDirectConnectGateway").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouteFilterPrefix> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteFilterPrefix::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<RouteFilterPrefix>> REQUESTED_ALLOWED_PREFIXES_TO_DIRECT_CONNECT_GATEWAY_FIELD = SdkField
            .<List<RouteFilterPrefix>> builder(MarshallingType.LIST)
            .memberName("requestedAllowedPrefixesToDirectConnectGateway")
            .getter(getter(DirectConnectGatewayAssociationProposal::requestedAllowedPrefixesToDirectConnectGateway))
            .setter(setter(Builder::requestedAllowedPrefixesToDirectConnectGateway))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("requestedAllowedPrefixesToDirectConnectGateway").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouteFilterPrefix> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteFilterPrefix::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPOSAL_ID_FIELD,
            DIRECT_CONNECT_GATEWAY_ID_FIELD, DIRECT_CONNECT_GATEWAY_OWNER_ACCOUNT_FIELD, PROPOSAL_STATE_FIELD,
            ASSOCIATED_GATEWAY_FIELD, EXISTING_ALLOWED_PREFIXES_TO_DIRECT_CONNECT_GATEWAY_FIELD,
            REQUESTED_ALLOWED_PREFIXES_TO_DIRECT_CONNECT_GATEWAY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String proposalId;

    private final String directConnectGatewayId;

    private final String directConnectGatewayOwnerAccount;

    private final String proposalState;

    private final AssociatedGateway associatedGateway;

    private final List<RouteFilterPrefix> existingAllowedPrefixesToDirectConnectGateway;

    private final List<RouteFilterPrefix> requestedAllowedPrefixesToDirectConnectGateway;

    private DirectConnectGatewayAssociationProposal(BuilderImpl builder) {
        this.proposalId = builder.proposalId;
        this.directConnectGatewayId = builder.directConnectGatewayId;
        this.directConnectGatewayOwnerAccount = builder.directConnectGatewayOwnerAccount;
        this.proposalState = builder.proposalState;
        this.associatedGateway = builder.associatedGateway;
        this.existingAllowedPrefixesToDirectConnectGateway = builder.existingAllowedPrefixesToDirectConnectGateway;
        this.requestedAllowedPrefixesToDirectConnectGateway = builder.requestedAllowedPrefixesToDirectConnectGateway;
    }

    /**
     * <p>
     * The ID of the association proposal.
     * </p>
     * 
     * @return The ID of the association proposal.
     */
    public String proposalId() {
        return proposalId;
    }

    /**
     * <p>
     * The ID of the Direct Connect gateway.
     * </p>
     * 
     * @return The ID of the Direct Connect gateway.
     */
    public String directConnectGatewayId() {
        return directConnectGatewayId;
    }

    /**
     * <p>
     * The ID of the AWS account that owns the Direct Connect gateway.
     * </p>
     * 
     * @return The ID of the AWS account that owns the Direct Connect gateway.
     */
    public String directConnectGatewayOwnerAccount() {
        return directConnectGatewayOwnerAccount;
    }

    /**
     * <p>
     * The state of the proposal. The following are possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>accepted</code>: The proposal has been accepted. The Direct Connect gateway association is available to use
     * in this state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleted</code>: The proposal has been deleted by the owner that made the proposal. The Direct Connect
     * gateway association cannot be used in this state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>requested</code>: The proposal has been requested. The Direct Connect gateway association cannot be used in
     * this state.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #proposalState}
     * will return {@link DirectConnectGatewayAssociationProposalState#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #proposalStateAsString}.
     * </p>
     * 
     * @return The state of the proposal. The following are possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>accepted</code>: The proposal has been accepted. The Direct Connect gateway association is
     *         available to use in this state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleted</code>: The proposal has been deleted by the owner that made the proposal. The Direct
     *         Connect gateway association cannot be used in this state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>requested</code>: The proposal has been requested. The Direct Connect gateway association cannot be
     *         used in this state.
     *         </p>
     *         </li>
     * @see DirectConnectGatewayAssociationProposalState
     */
    public DirectConnectGatewayAssociationProposalState proposalState() {
        return DirectConnectGatewayAssociationProposalState.fromValue(proposalState);
    }

    /**
     * <p>
     * The state of the proposal. The following are possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>accepted</code>: The proposal has been accepted. The Direct Connect gateway association is available to use
     * in this state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleted</code>: The proposal has been deleted by the owner that made the proposal. The Direct Connect
     * gateway association cannot be used in this state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>requested</code>: The proposal has been requested. The Direct Connect gateway association cannot be used in
     * this state.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #proposalState}
     * will return {@link DirectConnectGatewayAssociationProposalState#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #proposalStateAsString}.
     * </p>
     * 
     * @return The state of the proposal. The following are possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>accepted</code>: The proposal has been accepted. The Direct Connect gateway association is
     *         available to use in this state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleted</code>: The proposal has been deleted by the owner that made the proposal. The Direct
     *         Connect gateway association cannot be used in this state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>requested</code>: The proposal has been requested. The Direct Connect gateway association cannot be
     *         used in this state.
     *         </p>
     *         </li>
     * @see DirectConnectGatewayAssociationProposalState
     */
    public String proposalStateAsString() {
        return proposalState;
    }

    /**
     * <p>
     * Information about the associated gateway.
     * </p>
     * 
     * @return Information about the associated gateway.
     */
    public AssociatedGateway associatedGateway() {
        return associatedGateway;
    }

    /**
     * Returns true if the ExistingAllowedPrefixesToDirectConnectGateway property was specified by the sender (it may be
     * empty), or false if the sender did not specify the value (it will be empty). For responses returned by the SDK,
     * the sender is the AWS service.
     */
    public boolean hasExistingAllowedPrefixesToDirectConnectGateway() {
        return existingAllowedPrefixesToDirectConnectGateway != null
                && !(existingAllowedPrefixesToDirectConnectGateway instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The existing Amazon VPC prefixes advertised to the Direct Connect gateway.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExistingAllowedPrefixesToDirectConnectGateway()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The existing Amazon VPC prefixes advertised to the Direct Connect gateway.
     */
    public List<RouteFilterPrefix> existingAllowedPrefixesToDirectConnectGateway() {
        return existingAllowedPrefixesToDirectConnectGateway;
    }

    /**
     * Returns true if the RequestedAllowedPrefixesToDirectConnectGateway property was specified by the sender (it may
     * be empty), or false if the sender did not specify the value (it will be empty). For responses returned by the
     * SDK, the sender is the AWS service.
     */
    public boolean hasRequestedAllowedPrefixesToDirectConnectGateway() {
        return requestedAllowedPrefixesToDirectConnectGateway != null
                && !(requestedAllowedPrefixesToDirectConnectGateway instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon VPC prefixes to advertise to the Direct Connect gateway.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRequestedAllowedPrefixesToDirectConnectGateway()} to see if a value was sent in this
     * field.
     * </p>
     * 
     * @return The Amazon VPC prefixes to advertise to the Direct Connect gateway.
     */
    public List<RouteFilterPrefix> requestedAllowedPrefixesToDirectConnectGateway() {
        return requestedAllowedPrefixesToDirectConnectGateway;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(proposalId());
        hashCode = 31 * hashCode + Objects.hashCode(directConnectGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(directConnectGatewayOwnerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(proposalStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(associatedGateway());
        hashCode = 31 * hashCode + Objects.hashCode(existingAllowedPrefixesToDirectConnectGateway());
        hashCode = 31 * hashCode + Objects.hashCode(requestedAllowedPrefixesToDirectConnectGateway());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DirectConnectGatewayAssociationProposal)) {
            return false;
        }
        DirectConnectGatewayAssociationProposal other = (DirectConnectGatewayAssociationProposal) obj;
        return Objects.equals(proposalId(), other.proposalId())
                && Objects.equals(directConnectGatewayId(), other.directConnectGatewayId())
                && Objects.equals(directConnectGatewayOwnerAccount(), other.directConnectGatewayOwnerAccount())
                && Objects.equals(proposalStateAsString(), other.proposalStateAsString())
                && Objects.equals(associatedGateway(), other.associatedGateway())
                && Objects.equals(existingAllowedPrefixesToDirectConnectGateway(),
                        other.existingAllowedPrefixesToDirectConnectGateway())
                && Objects.equals(requestedAllowedPrefixesToDirectConnectGateway(),
                        other.requestedAllowedPrefixesToDirectConnectGateway());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DirectConnectGatewayAssociationProposal").add("ProposalId", proposalId())
                .add("DirectConnectGatewayId", directConnectGatewayId())
                .add("DirectConnectGatewayOwnerAccount", directConnectGatewayOwnerAccount())
                .add("ProposalState", proposalStateAsString()).add("AssociatedGateway", associatedGateway())
                .add("ExistingAllowedPrefixesToDirectConnectGateway", existingAllowedPrefixesToDirectConnectGateway())
                .add("RequestedAllowedPrefixesToDirectConnectGateway", requestedAllowedPrefixesToDirectConnectGateway()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "proposalId":
            return Optional.ofNullable(clazz.cast(proposalId()));
        case "directConnectGatewayId":
            return Optional.ofNullable(clazz.cast(directConnectGatewayId()));
        case "directConnectGatewayOwnerAccount":
            return Optional.ofNullable(clazz.cast(directConnectGatewayOwnerAccount()));
        case "proposalState":
            return Optional.ofNullable(clazz.cast(proposalStateAsString()));
        case "associatedGateway":
            return Optional.ofNullable(clazz.cast(associatedGateway()));
        case "existingAllowedPrefixesToDirectConnectGateway":
            return Optional.ofNullable(clazz.cast(existingAllowedPrefixesToDirectConnectGateway()));
        case "requestedAllowedPrefixesToDirectConnectGateway":
            return Optional.ofNullable(clazz.cast(requestedAllowedPrefixesToDirectConnectGateway()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DirectConnectGatewayAssociationProposal, T> g) {
        return obj -> g.apply((DirectConnectGatewayAssociationProposal) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DirectConnectGatewayAssociationProposal> {
        /**
         * <p>
         * The ID of the association proposal.
         * </p>
         * 
         * @param proposalId
         *        The ID of the association proposal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proposalId(String proposalId);

        /**
         * <p>
         * The ID of the Direct Connect gateway.
         * </p>
         * 
         * @param directConnectGatewayId
         *        The ID of the Direct Connect gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directConnectGatewayId(String directConnectGatewayId);

        /**
         * <p>
         * The ID of the AWS account that owns the Direct Connect gateway.
         * </p>
         * 
         * @param directConnectGatewayOwnerAccount
         *        The ID of the AWS account that owns the Direct Connect gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directConnectGatewayOwnerAccount(String directConnectGatewayOwnerAccount);

        /**
         * <p>
         * The state of the proposal. The following are possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>accepted</code>: The proposal has been accepted. The Direct Connect gateway association is available to
         * use in this state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleted</code>: The proposal has been deleted by the owner that made the proposal. The Direct Connect
         * gateway association cannot be used in this state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>requested</code>: The proposal has been requested. The Direct Connect gateway association cannot be
         * used in this state.
         * </p>
         * </li>
         * </ul>
         * 
         * @param proposalState
         *        The state of the proposal. The following are possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>accepted</code>: The proposal has been accepted. The Direct Connect gateway association is
         *        available to use in this state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleted</code>: The proposal has been deleted by the owner that made the proposal. The Direct
         *        Connect gateway association cannot be used in this state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>requested</code>: The proposal has been requested. The Direct Connect gateway association cannot
         *        be used in this state.
         *        </p>
         *        </li>
         * @see DirectConnectGatewayAssociationProposalState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DirectConnectGatewayAssociationProposalState
         */
        Builder proposalState(String proposalState);

        /**
         * <p>
         * The state of the proposal. The following are possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>accepted</code>: The proposal has been accepted. The Direct Connect gateway association is available to
         * use in this state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleted</code>: The proposal has been deleted by the owner that made the proposal. The Direct Connect
         * gateway association cannot be used in this state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>requested</code>: The proposal has been requested. The Direct Connect gateway association cannot be
         * used in this state.
         * </p>
         * </li>
         * </ul>
         * 
         * @param proposalState
         *        The state of the proposal. The following are possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>accepted</code>: The proposal has been accepted. The Direct Connect gateway association is
         *        available to use in this state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleted</code>: The proposal has been deleted by the owner that made the proposal. The Direct
         *        Connect gateway association cannot be used in this state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>requested</code>: The proposal has been requested. The Direct Connect gateway association cannot
         *        be used in this state.
         *        </p>
         *        </li>
         * @see DirectConnectGatewayAssociationProposalState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DirectConnectGatewayAssociationProposalState
         */
        Builder proposalState(DirectConnectGatewayAssociationProposalState proposalState);

        /**
         * <p>
         * Information about the associated gateway.
         * </p>
         * 
         * @param associatedGateway
         *        Information about the associated gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedGateway(AssociatedGateway associatedGateway);

        /**
         * <p>
         * Information about the associated gateway.
         * </p>
         * This is a convenience that creates an instance of the {@link AssociatedGateway.Builder} avoiding the need to
         * create one manually via {@link AssociatedGateway#builder()}.
         *
         * When the {@link Consumer} completes, {@link AssociatedGateway.Builder#build()} is called immediately and its
         * result is passed to {@link #associatedGateway(AssociatedGateway)}.
         * 
         * @param associatedGateway
         *        a consumer that will call methods on {@link AssociatedGateway.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associatedGateway(AssociatedGateway)
         */
        default Builder associatedGateway(Consumer<AssociatedGateway.Builder> associatedGateway) {
            return associatedGateway(AssociatedGateway.builder().applyMutation(associatedGateway).build());
        }

        /**
         * <p>
         * The existing Amazon VPC prefixes advertised to the Direct Connect gateway.
         * </p>
         * 
         * @param existingAllowedPrefixesToDirectConnectGateway
         *        The existing Amazon VPC prefixes advertised to the Direct Connect gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder existingAllowedPrefixesToDirectConnectGateway(
                Collection<RouteFilterPrefix> existingAllowedPrefixesToDirectConnectGateway);

        /**
         * <p>
         * The existing Amazon VPC prefixes advertised to the Direct Connect gateway.
         * </p>
         * 
         * @param existingAllowedPrefixesToDirectConnectGateway
         *        The existing Amazon VPC prefixes advertised to the Direct Connect gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder existingAllowedPrefixesToDirectConnectGateway(RouteFilterPrefix... existingAllowedPrefixesToDirectConnectGateway);

        /**
         * <p>
         * The existing Amazon VPC prefixes advertised to the Direct Connect gateway.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RouteFilterPrefix>.Builder} avoiding the
         * need to create one manually via {@link List<RouteFilterPrefix>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RouteFilterPrefix>.Builder#build()} is called immediately
         * and its result is passed to {@link #existingAllowedPrefixesToDirectConnectGateway(List<RouteFilterPrefix>)}.
         * 
         * @param existingAllowedPrefixesToDirectConnectGateway
         *        a consumer that will call methods on {@link List<RouteFilterPrefix>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #existingAllowedPrefixesToDirectConnectGateway(List<RouteFilterPrefix>)
         */
        Builder existingAllowedPrefixesToDirectConnectGateway(
                Consumer<RouteFilterPrefix.Builder>... existingAllowedPrefixesToDirectConnectGateway);

        /**
         * <p>
         * The Amazon VPC prefixes to advertise to the Direct Connect gateway.
         * </p>
         * 
         * @param requestedAllowedPrefixesToDirectConnectGateway
         *        The Amazon VPC prefixes to advertise to the Direct Connect gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestedAllowedPrefixesToDirectConnectGateway(
                Collection<RouteFilterPrefix> requestedAllowedPrefixesToDirectConnectGateway);

        /**
         * <p>
         * The Amazon VPC prefixes to advertise to the Direct Connect gateway.
         * </p>
         * 
         * @param requestedAllowedPrefixesToDirectConnectGateway
         *        The Amazon VPC prefixes to advertise to the Direct Connect gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestedAllowedPrefixesToDirectConnectGateway(
                RouteFilterPrefix... requestedAllowedPrefixesToDirectConnectGateway);

        /**
         * <p>
         * The Amazon VPC prefixes to advertise to the Direct Connect gateway.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RouteFilterPrefix>.Builder} avoiding the
         * need to create one manually via {@link List<RouteFilterPrefix>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RouteFilterPrefix>.Builder#build()} is called immediately
         * and its result is passed to {@link #requestedAllowedPrefixesToDirectConnectGateway(List<RouteFilterPrefix>)}.
         * 
         * @param requestedAllowedPrefixesToDirectConnectGateway
         *        a consumer that will call methods on {@link List<RouteFilterPrefix>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requestedAllowedPrefixesToDirectConnectGateway(List<RouteFilterPrefix>)
         */
        Builder requestedAllowedPrefixesToDirectConnectGateway(
                Consumer<RouteFilterPrefix.Builder>... requestedAllowedPrefixesToDirectConnectGateway);
    }

    static final class BuilderImpl implements Builder {
        private String proposalId;

        private String directConnectGatewayId;

        private String directConnectGatewayOwnerAccount;

        private String proposalState;

        private AssociatedGateway associatedGateway;

        private List<RouteFilterPrefix> existingAllowedPrefixesToDirectConnectGateway = DefaultSdkAutoConstructList.getInstance();

        private List<RouteFilterPrefix> requestedAllowedPrefixesToDirectConnectGateway = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DirectConnectGatewayAssociationProposal model) {
            proposalId(model.proposalId);
            directConnectGatewayId(model.directConnectGatewayId);
            directConnectGatewayOwnerAccount(model.directConnectGatewayOwnerAccount);
            proposalState(model.proposalState);
            associatedGateway(model.associatedGateway);
            existingAllowedPrefixesToDirectConnectGateway(model.existingAllowedPrefixesToDirectConnectGateway);
            requestedAllowedPrefixesToDirectConnectGateway(model.requestedAllowedPrefixesToDirectConnectGateway);
        }

        public final String getProposalId() {
            return proposalId;
        }

        @Override
        public final Builder proposalId(String proposalId) {
            this.proposalId = proposalId;
            return this;
        }

        public final void setProposalId(String proposalId) {
            this.proposalId = proposalId;
        }

        public final String getDirectConnectGatewayId() {
            return directConnectGatewayId;
        }

        @Override
        public final Builder directConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
            return this;
        }

        public final void setDirectConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
        }

        public final String getDirectConnectGatewayOwnerAccount() {
            return directConnectGatewayOwnerAccount;
        }

        @Override
        public final Builder directConnectGatewayOwnerAccount(String directConnectGatewayOwnerAccount) {
            this.directConnectGatewayOwnerAccount = directConnectGatewayOwnerAccount;
            return this;
        }

        public final void setDirectConnectGatewayOwnerAccount(String directConnectGatewayOwnerAccount) {
            this.directConnectGatewayOwnerAccount = directConnectGatewayOwnerAccount;
        }

        public final String getProposalState() {
            return proposalState;
        }

        @Override
        public final Builder proposalState(String proposalState) {
            this.proposalState = proposalState;
            return this;
        }

        @Override
        public final Builder proposalState(DirectConnectGatewayAssociationProposalState proposalState) {
            this.proposalState(proposalState == null ? null : proposalState.toString());
            return this;
        }

        public final void setProposalState(String proposalState) {
            this.proposalState = proposalState;
        }

        public final AssociatedGateway.Builder getAssociatedGateway() {
            return associatedGateway != null ? associatedGateway.toBuilder() : null;
        }

        @Override
        public final Builder associatedGateway(AssociatedGateway associatedGateway) {
            this.associatedGateway = associatedGateway;
            return this;
        }

        public final void setAssociatedGateway(AssociatedGateway.BuilderImpl associatedGateway) {
            this.associatedGateway = associatedGateway != null ? associatedGateway.build() : null;
        }

        public final Collection<RouteFilterPrefix.Builder> getExistingAllowedPrefixesToDirectConnectGateway() {
            return existingAllowedPrefixesToDirectConnectGateway != null ? existingAllowedPrefixesToDirectConnectGateway.stream()
                    .map(RouteFilterPrefix::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder existingAllowedPrefixesToDirectConnectGateway(
                Collection<RouteFilterPrefix> existingAllowedPrefixesToDirectConnectGateway) {
            this.existingAllowedPrefixesToDirectConnectGateway = RouteFilterPrefixListCopier
                    .copy(existingAllowedPrefixesToDirectConnectGateway);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder existingAllowedPrefixesToDirectConnectGateway(
                RouteFilterPrefix... existingAllowedPrefixesToDirectConnectGateway) {
            existingAllowedPrefixesToDirectConnectGateway(Arrays.asList(existingAllowedPrefixesToDirectConnectGateway));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder existingAllowedPrefixesToDirectConnectGateway(
                Consumer<RouteFilterPrefix.Builder>... existingAllowedPrefixesToDirectConnectGateway) {
            existingAllowedPrefixesToDirectConnectGateway(Stream.of(existingAllowedPrefixesToDirectConnectGateway)
                    .map(c -> RouteFilterPrefix.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setExistingAllowedPrefixesToDirectConnectGateway(
                Collection<RouteFilterPrefix.BuilderImpl> existingAllowedPrefixesToDirectConnectGateway) {
            this.existingAllowedPrefixesToDirectConnectGateway = RouteFilterPrefixListCopier
                    .copyFromBuilder(existingAllowedPrefixesToDirectConnectGateway);
        }

        public final Collection<RouteFilterPrefix.Builder> getRequestedAllowedPrefixesToDirectConnectGateway() {
            return requestedAllowedPrefixesToDirectConnectGateway != null ? requestedAllowedPrefixesToDirectConnectGateway
                    .stream().map(RouteFilterPrefix::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder requestedAllowedPrefixesToDirectConnectGateway(
                Collection<RouteFilterPrefix> requestedAllowedPrefixesToDirectConnectGateway) {
            this.requestedAllowedPrefixesToDirectConnectGateway = RouteFilterPrefixListCopier
                    .copy(requestedAllowedPrefixesToDirectConnectGateway);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requestedAllowedPrefixesToDirectConnectGateway(
                RouteFilterPrefix... requestedAllowedPrefixesToDirectConnectGateway) {
            requestedAllowedPrefixesToDirectConnectGateway(Arrays.asList(requestedAllowedPrefixesToDirectConnectGateway));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requestedAllowedPrefixesToDirectConnectGateway(
                Consumer<RouteFilterPrefix.Builder>... requestedAllowedPrefixesToDirectConnectGateway) {
            requestedAllowedPrefixesToDirectConnectGateway(Stream.of(requestedAllowedPrefixesToDirectConnectGateway)
                    .map(c -> RouteFilterPrefix.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRequestedAllowedPrefixesToDirectConnectGateway(
                Collection<RouteFilterPrefix.BuilderImpl> requestedAllowedPrefixesToDirectConnectGateway) {
            this.requestedAllowedPrefixesToDirectConnectGateway = RouteFilterPrefixListCopier
                    .copyFromBuilder(requestedAllowedPrefixesToDirectConnectGateway);
        }

        @Override
        public DirectConnectGatewayAssociationProposal build() {
            return new DirectConnectGatewayAssociationProposal(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
