/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.Authentication;
import software.amazon.awssdk.services.elasticache.model.UserGroupIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class User
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, User> {
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserId").getter(User.getter(User::userId)).setter(User.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()}).build();
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserName").getter(User.getter(User::userName)).setter(User.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(User.getter(User::status)).setter(User.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(User.getter(User::engine)).setter(User.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> ACCESS_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessString").getter(User.getter(User::accessString)).setter(User.setter(Builder::accessString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessString").build()}).build();
    private static final SdkField<List<String>> USER_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserGroupIds").getter(User.getter(User::userGroupIds)).setter(User.setter(Builder::userGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Authentication> AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Authentication").getter(User.getter(User::authentication)).setter(User.setter(Builder::authentication)).constructor(Authentication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Authentication").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ARN").getter(User.getter(User::arn)).setter(User.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ID_FIELD, USER_NAME_FIELD, STATUS_FIELD, ENGINE_FIELD, ACCESS_STRING_FIELD, USER_GROUP_IDS_FIELD, AUTHENTICATION_FIELD, ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String userId;
    private final String userName;
    private final String status;
    private final String engine;
    private final String accessString;
    private final List<String> userGroupIds;
    private final Authentication authentication;
    private final String arn;

    private User(BuilderImpl builder) {
        this.userId = builder.userId;
        this.userName = builder.userName;
        this.status = builder.status;
        this.engine = builder.engine;
        this.accessString = builder.accessString;
        this.userGroupIds = builder.userGroupIds;
        this.authentication = builder.authentication;
        this.arn = builder.arn;
    }

    public String userId() {
        return this.userId;
    }

    public String userName() {
        return this.userName;
    }

    public String status() {
        return this.status;
    }

    public String engine() {
        return this.engine;
    }

    public String accessString() {
        return this.accessString;
    }

    public boolean hasUserGroupIds() {
        return this.userGroupIds != null && !(this.userGroupIds instanceof SdkAutoConstructList);
    }

    public List<String> userGroupIds() {
        return this.userGroupIds;
    }

    public Authentication authentication() {
        return this.authentication;
    }

    public String arn() {
        return this.arn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.authentication());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User)obj;
        return Objects.equals(this.userId(), other.userId()) && Objects.equals(this.userName(), other.userName()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.accessString(), other.accessString()) && Objects.equals(this.userGroupIds(), other.userGroupIds()) && Objects.equals(this.authentication(), other.authentication()) && Objects.equals(this.arn(), other.arn());
    }

    public String toString() {
        return ToString.builder((String)"User").add("UserId", (Object)this.userId()).add("UserName", (Object)this.userName()).add("Status", (Object)this.status()).add("Engine", (Object)this.engine()).add("AccessString", (Object)this.accessString()).add("UserGroupIds", this.userGroupIds()).add("Authentication", (Object)this.authentication()).add("ARN", (Object)this.arn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "AccessString": {
                return Optional.ofNullable(clazz.cast(this.accessString()));
            }
            case "UserGroupIds": {
                return Optional.ofNullable(clazz.cast(this.userGroupIds()));
            }
            case "Authentication": {
                return Optional.ofNullable(clazz.cast(this.authentication()));
            }
            case "ARN": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<User, T> g) {
        return obj -> g.apply((User)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String userId;
        private String userName;
        private String status;
        private String engine;
        private String accessString;
        private List<String> userGroupIds = DefaultSdkAutoConstructList.getInstance();
        private Authentication authentication;
        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(User model) {
            this.userId(model.userId);
            this.userName(model.userName);
            this.status(model.status);
            this.engine(model.engine);
            this.accessString(model.accessString);
            this.userGroupIds(model.userGroupIds);
            this.authentication(model.authentication);
            this.arn(model.arn);
        }

        public final String getUserId() {
            return this.userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getAccessString() {
            return this.accessString;
        }

        @Override
        public final Builder accessString(String accessString) {
            this.accessString = accessString;
            return this;
        }

        public final void setAccessString(String accessString) {
            this.accessString = accessString;
        }

        public final Collection<String> getUserGroupIds() {
            return this.userGroupIds;
        }

        @Override
        public final Builder userGroupIds(Collection<String> userGroupIds) {
            this.userGroupIds = UserGroupIdListCopier.copy(userGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userGroupIds(String ... userGroupIds) {
            this.userGroupIds(Arrays.asList(userGroupIds));
            return this;
        }

        public final void setUserGroupIds(Collection<String> userGroupIds) {
            this.userGroupIds = UserGroupIdListCopier.copy(userGroupIds);
        }

        public final Authentication.Builder getAuthentication() {
            return this.authentication != null ? this.authentication.toBuilder() : null;
        }

        @Override
        public final Builder authentication(Authentication authentication) {
            this.authentication = authentication;
            return this;
        }

        public final void setAuthentication(Authentication.BuilderImpl authentication) {
            this.authentication = authentication != null ? authentication.build() : null;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public User build() {
            return new User(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, User> {
        public Builder userId(String var1);

        public Builder userName(String var1);

        public Builder status(String var1);

        public Builder engine(String var1);

        public Builder accessString(String var1);

        public Builder userGroupIds(Collection<String> var1);

        public Builder userGroupIds(String ... var1);

        public Builder authentication(Authentication var1);

        default public Builder authentication(Consumer<Authentication.Builder> authentication) {
            return this.authentication((Authentication)((Authentication.Builder)Authentication.builder().applyMutation(authentication)).build());
        }

        public Builder arn(String var1);
    }
}

