/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticinference.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticinference.model.ElasticInferenceAcceleratorHealth;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ElasticInferenceAccelerator
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ElasticInferenceAccelerator> {
    private static final SdkField<ElasticInferenceAcceleratorHealth> ACCELERATOR_HEALTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("acceleratorHealth").getter(ElasticInferenceAccelerator.getter(ElasticInferenceAccelerator::acceleratorHealth)).setter(ElasticInferenceAccelerator.setter(Builder::acceleratorHealth)).constructor(ElasticInferenceAcceleratorHealth::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceleratorHealth").build()}).build();
    private static final SdkField<String> ACCELERATOR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("acceleratorType").getter(ElasticInferenceAccelerator.getter(ElasticInferenceAccelerator::acceleratorType)).setter(ElasticInferenceAccelerator.setter(Builder::acceleratorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceleratorType").build()}).build();
    private static final SdkField<String> ACCELERATOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("acceleratorId").getter(ElasticInferenceAccelerator.getter(ElasticInferenceAccelerator::acceleratorId)).setter(ElasticInferenceAccelerator.setter(Builder::acceleratorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceleratorId").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("availabilityZone").getter(ElasticInferenceAccelerator.getter(ElasticInferenceAccelerator::availabilityZone)).setter(ElasticInferenceAccelerator.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()}).build();
    private static final SdkField<String> ATTACHED_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("attachedResource").getter(ElasticInferenceAccelerator.getter(ElasticInferenceAccelerator::attachedResource)).setter(ElasticInferenceAccelerator.setter(Builder::attachedResource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachedResource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATOR_HEALTH_FIELD, ACCELERATOR_TYPE_FIELD, ACCELERATOR_ID_FIELD, AVAILABILITY_ZONE_FIELD, ATTACHED_RESOURCE_FIELD));
    private static final long serialVersionUID = 1L;
    private final ElasticInferenceAcceleratorHealth acceleratorHealth;
    private final String acceleratorType;
    private final String acceleratorId;
    private final String availabilityZone;
    private final String attachedResource;

    private ElasticInferenceAccelerator(BuilderImpl builder) {
        this.acceleratorHealth = builder.acceleratorHealth;
        this.acceleratorType = builder.acceleratorType;
        this.acceleratorId = builder.acceleratorId;
        this.availabilityZone = builder.availabilityZone;
        this.attachedResource = builder.attachedResource;
    }

    public ElasticInferenceAcceleratorHealth acceleratorHealth() {
        return this.acceleratorHealth;
    }

    public String acceleratorType() {
        return this.acceleratorType;
    }

    public String acceleratorId() {
        return this.acceleratorId;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String attachedResource() {
        return this.attachedResource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.acceleratorHealth());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceleratorType());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceleratorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachedResource());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticInferenceAccelerator)) {
            return false;
        }
        ElasticInferenceAccelerator other = (ElasticInferenceAccelerator)obj;
        return Objects.equals(this.acceleratorHealth(), other.acceleratorHealth()) && Objects.equals(this.acceleratorType(), other.acceleratorType()) && Objects.equals(this.acceleratorId(), other.acceleratorId()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.attachedResource(), other.attachedResource());
    }

    public String toString() {
        return ToString.builder((String)"ElasticInferenceAccelerator").add("AcceleratorHealth", (Object)this.acceleratorHealth()).add("AcceleratorType", (Object)this.acceleratorType()).add("AcceleratorId", (Object)this.acceleratorId()).add("AvailabilityZone", (Object)this.availabilityZone()).add("AttachedResource", (Object)this.attachedResource()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "acceleratorHealth": {
                return Optional.ofNullable(clazz.cast(this.acceleratorHealth()));
            }
            case "acceleratorType": {
                return Optional.ofNullable(clazz.cast(this.acceleratorType()));
            }
            case "acceleratorId": {
                return Optional.ofNullable(clazz.cast(this.acceleratorId()));
            }
            case "availabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "attachedResource": {
                return Optional.ofNullable(clazz.cast(this.attachedResource()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ElasticInferenceAccelerator, T> g) {
        return obj -> g.apply((ElasticInferenceAccelerator)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ElasticInferenceAcceleratorHealth acceleratorHealth;
        private String acceleratorType;
        private String acceleratorId;
        private String availabilityZone;
        private String attachedResource;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticInferenceAccelerator model) {
            this.acceleratorHealth(model.acceleratorHealth);
            this.acceleratorType(model.acceleratorType);
            this.acceleratorId(model.acceleratorId);
            this.availabilityZone(model.availabilityZone);
            this.attachedResource(model.attachedResource);
        }

        public final ElasticInferenceAcceleratorHealth.Builder getAcceleratorHealth() {
            return this.acceleratorHealth != null ? this.acceleratorHealth.toBuilder() : null;
        }

        @Override
        public final Builder acceleratorHealth(ElasticInferenceAcceleratorHealth acceleratorHealth) {
            this.acceleratorHealth = acceleratorHealth;
            return this;
        }

        public final void setAcceleratorHealth(ElasticInferenceAcceleratorHealth.BuilderImpl acceleratorHealth) {
            this.acceleratorHealth = acceleratorHealth != null ? acceleratorHealth.build() : null;
        }

        public final String getAcceleratorType() {
            return this.acceleratorType;
        }

        @Override
        public final Builder acceleratorType(String acceleratorType) {
            this.acceleratorType = acceleratorType;
            return this;
        }

        public final void setAcceleratorType(String acceleratorType) {
            this.acceleratorType = acceleratorType;
        }

        public final String getAcceleratorId() {
            return this.acceleratorId;
        }

        @Override
        public final Builder acceleratorId(String acceleratorId) {
            this.acceleratorId = acceleratorId;
            return this;
        }

        public final void setAcceleratorId(String acceleratorId) {
            this.acceleratorId = acceleratorId;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getAttachedResource() {
            return this.attachedResource;
        }

        @Override
        public final Builder attachedResource(String attachedResource) {
            this.attachedResource = attachedResource;
            return this;
        }

        public final void setAttachedResource(String attachedResource) {
            this.attachedResource = attachedResource;
        }

        public ElasticInferenceAccelerator build() {
            return new ElasticInferenceAccelerator(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ElasticInferenceAccelerator> {
        public Builder acceleratorHealth(ElasticInferenceAcceleratorHealth var1);

        default public Builder acceleratorHealth(Consumer<ElasticInferenceAcceleratorHealth.Builder> acceleratorHealth) {
            return this.acceleratorHealth((ElasticInferenceAcceleratorHealth)((ElasticInferenceAcceleratorHealth.Builder)ElasticInferenceAcceleratorHealth.builder().applyMutation(acceleratorHealth)).build());
        }

        public Builder acceleratorType(String var1);

        public Builder acceleratorId(String var1);

        public Builder availabilityZone(String var1);

        public Builder attachedResource(String var1);
    }
}

