/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTargetGroupsResponse extends ElasticLoadBalancingV2Response implements
        ToCopyableBuilder<DescribeTargetGroupsResponse.Builder, DescribeTargetGroupsResponse> {
    private static final SdkField<List<TargetGroup>> TARGET_GROUPS_FIELD = SdkField
            .<List<TargetGroup>> builder(MarshallingType.LIST)
            .memberName("TargetGroups")
            .getter(getter(DescribeTargetGroupsResponse::targetGroups))
            .setter(setter(Builder::targetGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TargetGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(TargetGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextMarker").getter(getter(DescribeTargetGroupsResponse::nextMarker))
            .setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_GROUPS_FIELD,
            NEXT_MARKER_FIELD));

    private final List<TargetGroup> targetGroups;

    private final String nextMarker;

    private DescribeTargetGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.targetGroups = builder.targetGroups;
        this.nextMarker = builder.nextMarker;
    }

    /**
     * Returns true if the TargetGroups property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTargetGroups() {
        return targetGroups != null && !(targetGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the target groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTargetGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the target groups.
     */
    public List<TargetGroup> targetGroups() {
        return targetGroups;
    }

    /**
     * <p>
     * If there are additional results, this is the marker for the next set of results. Otherwise, this is null.
     * </p>
     * 
     * @return If there are additional results, this is the marker for the next set of results. Otherwise, this is null.
     */
    public String nextMarker() {
        return nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(targetGroups());
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTargetGroupsResponse)) {
            return false;
        }
        DescribeTargetGroupsResponse other = (DescribeTargetGroupsResponse) obj;
        return Objects.equals(targetGroups(), other.targetGroups()) && Objects.equals(nextMarker(), other.nextMarker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeTargetGroupsResponse").add("TargetGroups", targetGroups())
                .add("NextMarker", nextMarker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetGroups":
            return Optional.ofNullable(clazz.cast(targetGroups()));
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTargetGroupsResponse, T> g) {
        return obj -> g.apply((DescribeTargetGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticLoadBalancingV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTargetGroupsResponse> {
        /**
         * <p>
         * Information about the target groups.
         * </p>
         * 
         * @param targetGroups
         *        Information about the target groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroups(Collection<TargetGroup> targetGroups);

        /**
         * <p>
         * Information about the target groups.
         * </p>
         * 
         * @param targetGroups
         *        Information about the target groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroups(TargetGroup... targetGroups);

        /**
         * <p>
         * Information about the target groups.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TargetGroup>.Builder} avoiding the need to
         * create one manually via {@link List<TargetGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TargetGroup>.Builder#build()} is called immediately and its
         * result is passed to {@link #targetGroups(List<TargetGroup>)}.
         * 
         * @param targetGroups
         *        a consumer that will call methods on {@link List<TargetGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetGroups(List<TargetGroup>)
         */
        Builder targetGroups(Consumer<TargetGroup.Builder>... targetGroups);

        /**
         * <p>
         * If there are additional results, this is the marker for the next set of results. Otherwise, this is null.
         * </p>
         * 
         * @param nextMarker
         *        If there are additional results, this is the marker for the next set of results. Otherwise, this is
         *        null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);
    }

    static final class BuilderImpl extends ElasticLoadBalancingV2Response.BuilderImpl implements Builder {
        private List<TargetGroup> targetGroups = DefaultSdkAutoConstructList.getInstance();

        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTargetGroupsResponse model) {
            super(model);
            targetGroups(model.targetGroups);
            nextMarker(model.nextMarker);
        }

        public final Collection<TargetGroup.Builder> getTargetGroups() {
            return targetGroups != null ? targetGroups.stream().map(TargetGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targetGroups(Collection<TargetGroup> targetGroups) {
            this.targetGroups = TargetGroupsCopier.copy(targetGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroups(TargetGroup... targetGroups) {
            targetGroups(Arrays.asList(targetGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroups(Consumer<TargetGroup.Builder>... targetGroups) {
            targetGroups(Stream.of(targetGroups).map(c -> TargetGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTargetGroups(Collection<TargetGroup.BuilderImpl> targetGroups) {
            this.targetGroups = TargetGroupsCopier.copyFromBuilder(targetGroups);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public DescribeTargetGroupsResponse build() {
            return new DescribeTargetGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
